/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.cookie;

import io.hyperfoil.api.session.Session;
import io.hyperfoil.http.HttpUtil;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.cookie.CookieRecorder;
import io.hyperfoil.impl.Util;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class CookieStore
implements Session.Resource {
    private static final Logger log = LogManager.getLogger(CookieRecorder.class);
    public static final Session.ResourceKey<CookieStore> COOKIES = new Session.ResourceKey<CookieStore>(){};
    private static final Attribute[] ATTRIBUTES = Attribute.values();
    private static final int MAX_SITES = 16;
    private final Cookie[] cookies = new Cookie[16];

    CookieStore() {
        for (int i = 0; i < this.cookies.length; ++i) {
            this.cookies[i] = new Cookie();
        }
    }

    public void onSessionReset(Session session) {
        for (int i = 0; i < this.cookies.length; ++i) {
            this.cookies[i].clear();
        }
    }

    public void setCookie(CharSequence requestOrigin, CharSequence requestPath, CharSequence seq) {
        int nameEnd = HttpUtil.indexOf(seq, 0, '=');
        if (nameEnd < 0) {
            log.warn("Invalid cookie value (no name): {}", (Object)seq);
            return;
        }
        CharSequence name = seq.subSequence(0, nameEnd);
        int valueEnd = HttpUtil.indexOf(seq, nameEnd + 1, ';');
        CharSequence nameValue = seq.subSequence(0, valueEnd);
        CharSequence domain = null;
        CharSequence path = null;
        boolean secure = false;
        long maxAge = Long.MAX_VALUE;
        long expires = Long.MAX_VALUE;
        ++valueEnd;
        while (valueEnd < seq.length()) {
            while (valueEnd < seq.length() && seq.charAt(valueEnd) == ' ') {
                ++valueEnd;
            }
            int semIndex = HttpUtil.indexOf(seq, valueEnd, ';');
            for (int a = 0; a < ATTRIBUTES.length; ++a) {
                Attribute attribute = ATTRIBUTES[a];
                if (!CookieStore.matchPrefix(attribute.text, seq, valueEnd)) continue;
                switch (attribute.ordinal()) {
                    case 0: {
                        expires = HttpUtil.parseDate(seq, valueEnd + attribute.text.length(), semIndex);
                        break;
                    }
                    case 1: {
                        maxAge = Util.parseLong((CharSequence)seq, (int)(valueEnd + attribute.text.length()), (int)semIndex, (long)Long.MAX_VALUE);
                        break;
                    }
                    case 2: {
                        if (valueEnd < seq.length() && seq.charAt(valueEnd) == '.') {
                            ++valueEnd;
                        }
                        domain = seq.subSequence(valueEnd + attribute.text.length(), semIndex);
                        break;
                    }
                    case 3: {
                        path = seq.subSequence(valueEnd + attribute.text.length(), semIndex);
                        break;
                    }
                    case 4: {
                        secure = true;
                        break;
                    }
                }
                break;
            }
            valueEnd = semIndex + 1;
        }
        boolean exactDomain = false;
        if (domain == null) {
            domain = requestOrigin;
            exactDomain = true;
        } else if (!CookieStore.isSubdomain(requestOrigin, domain)) {
            log.trace("Refusing to store cookie for domain {}, origin is {}", (Object)domain, (Object)requestOrigin);
            return;
        }
        int requestPathLastSlashIndex = HttpUtil.lastIndexOf(requestPath, requestPath.length(), '/');
        if (path == null) {
            path = requestPath.subSequence(0, requestPathLastSlashIndex + 1);
        } else if (!CookieStore.isSubpath(requestPath, requestPathLastSlashIndex + 1, path, path.length())) {
            log.trace("Refusing to store cookie for path {}, origin is {}", (Object)path, (Object)requestPath);
            return;
        }
        long now = System.currentTimeMillis();
        if (maxAge != Long.MAX_VALUE) {
            expires = now + maxAge * 1000L;
        }
        for (int i = 0; i < this.cookies.length; ++i) {
            if (this.cookies[i].name != null && this.cookies[i].name.length() != 0 && (!AsciiString.contentEquals((CharSequence)this.cookies[i].name, (CharSequence)name) || !AsciiString.contentEquals((CharSequence)this.cookies[i].domain, (CharSequence)domain) || !AsciiString.contentEquals((CharSequence)this.cookies[i].path, (CharSequence)path))) continue;
            if (nameValue.length() == valueEnd + 1 || expires <= now) {
                this.cookies[i].name = "";
            } else {
                this.cookies[i].name = name;
                this.cookies[i].nameValue = nameValue;
                this.cookies[i].domain = domain;
                this.cookies[i].exactDomain = exactDomain;
                this.cookies[i].path = path;
                this.cookies[i].secure = secure;
                this.cookies[i].expires = expires;
            }
            return;
        }
        log.error("Exceeded number of cookies, dropping: {}", (Object)seq);
    }

    private static boolean isSubpath(CharSequence subpath, int subpathLength, CharSequence path, int pathLength) {
        if (pathLength > subpathLength) {
            return false;
        }
        return AsciiString.regionMatches((CharSequence)subpath, (boolean)false, (int)0, (CharSequence)path, (int)0, (int)pathLength);
    }

    private static boolean isSubdomain(CharSequence subdomain, CharSequence domain) {
        if (subdomain.length() < domain.length()) {
            return false;
        }
        return AsciiString.regionMatches((CharSequence)subdomain, (boolean)false, (int)(subdomain.length() - domain.length()), (CharSequence)domain, (int)0, (int)domain.length());
    }

    private static boolean matchPrefix(CharSequence prefix, CharSequence seq, int begin) {
        int maxLength = prefix.length();
        if (maxLength > seq.length() - begin) {
            return false;
        }
        for (int i = 0; i < maxLength; ++i) {
            if (prefix.charAt(i) == Character.toLowerCase(seq.charAt(begin + i))) continue;
            return false;
        }
        return true;
    }

    public void appendCookies(HttpRequestWriter requestWriter) {
        String domain = requestWriter.connection().host();
        String path = requestWriter.request().path;
        long now = System.currentTimeMillis();
        for (int i = 0; i < this.cookies.length; ++i) {
            Cookie c = this.cookies[i];
            if (c.name == null) break;
            if (c.name.length() == 0 || (c.exactDomain || !CookieStore.isSubdomain(domain, c.domain)) && !AsciiString.contentEquals((CharSequence)domain, (CharSequence)c.domain) || !CookieStore.isSubpath(path, path.length(), c.path, c.path.length()) || c.secure && !requestWriter.connection().isSecure()) continue;
            if (now >= c.expires) {
                c.name = "";
                continue;
            }
            requestWriter.putHeader((CharSequence)HttpHeaderNames.COOKIE, c.nameValue);
        }
    }

    static class Cookie {
        CharSequence name;
        CharSequence nameValue;
        CharSequence domain;
        boolean exactDomain;
        CharSequence path;
        long expires;
        boolean secure;

        Cookie() {
        }

        public void clear() {
            this.name = null;
            this.nameValue = null;
            this.domain = null;
            this.exactDomain = false;
            this.path = null;
            this.expires = 0L;
            this.secure = false;
        }
    }

    private static enum Attribute {
        EXPIRES("expires="),
        MAX_AGE("max-age="),
        DOMAIN("domain="),
        PATH("path="),
        SECURE("secure"),
        HTTPONLY("httponly"),
        EXTENSION("");

        final CharSequence text;

        private Attribute(CharSequence text) {
            this.text = text;
        }
    }
}

