/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.cookie;

import io.hyperfoil.api.session.Session;
import io.hyperfoil.function.SerializableBiConsumer;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.cookie.CookieStore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CookieAppender
implements SerializableBiConsumer<Session, HttpRequestWriter> {
    private static final Logger log = LogManager.getLogger(CookieAppender.class);

    public void accept(Session session, HttpRequestWriter writer) {
        CookieStore cookies = (CookieStore)session.getResource(CookieStore.COOKIES);
        if (cookies == null) {
            log.error("No cookie store in the session. Did you add CookieRecorder?");
            return;
        }
        cookies.appendCookies(writer);
    }
}

