/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.core.util.Watermarks;
import io.hyperfoil.http.api.ConnectionConsumer;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.config.ConnectionPoolConfig;
import io.hyperfoil.http.connection.ConnectionPoolStats;
import io.hyperfoil.http.connection.ConnectionReceiver;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.ScheduledFuture;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

class SharedConnectionPool
extends ConnectionPoolStats
implements HttpConnectionPool {
    private static final Logger log = LogManager.getLogger(SharedConnectionPool.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int MAX_FAILURES = 100;
    private final HttpClientPoolImpl clientPool;
    private final ArrayList<HttpConnection> connections = new ArrayList();
    private final ArrayDeque<HttpConnection> available;
    private final List<HttpConnection> temporaryInFlight;
    private final ConnectionReceiver handleNewConnection = this::handleNewConnection;
    private final Runnable checkCreateConnections = this::checkCreateConnections;
    private final Runnable onConnectFailure = this::onConnectFailure;
    private final ConnectionPoolConfig sizeConfig;
    private final EventLoop eventLoop;
    private int connecting;
    private int created;
    private int closed;
    private int availableClosed;
    private int failures;
    private Handler<AsyncResult<Void>> startedHandler;
    private boolean shutdown;
    private final Deque<ConnectionConsumer> waiting = new ArrayDeque<ConnectionConsumer>();
    private ScheduledFuture<?> pulseFuture;
    private ScheduledFuture<?> keepAliveFuture;

    SharedConnectionPool(HttpClientPoolImpl clientPool, EventLoop eventLoop, ConnectionPoolConfig sizeConfig) {
        super(clientPool.authority);
        this.clientPool = clientPool;
        this.sizeConfig = sizeConfig;
        this.eventLoop = eventLoop;
        this.available = new ArrayDeque(sizeConfig.max());
        this.temporaryInFlight = new ArrayList<HttpConnection>(sizeConfig.max());
    }

    @Override
    public HttpClientPool clientPool() {
        return this.clientPool;
    }

    private HttpConnection acquireNow(boolean exclusiveConnection) {
        assert (this.eventLoop.inEventLoop());
        try {
            while (true) {
                HttpConnection connection;
                if ((connection = this.available.pollFirst()) == null) {
                    log.debug("No connection to {} available, currently used {}", (Object)this.authority, (Object)this.usedConnections.current());
                    HttpConnection httpConnection = null;
                    return httpConnection;
                }
                if (!connection.isClosed()) {
                    if (exclusiveConnection && connection.inFlight() > 0) {
                        this.temporaryInFlight.add(connection);
                        continue;
                    }
                    this.inFlight.incrementUsed();
                    if (connection.inFlight() == 0) {
                        this.usedConnections.incrementUsed();
                    }
                    connection.onAcquire();
                    HttpConnection httpConnection = connection;
                    return httpConnection;
                }
                --this.availableClosed;
                log.trace("Connection {} to {} is already closed", (Object)connection, (Object)this.authority);
            }
        }
        finally {
            if (!this.temporaryInFlight.isEmpty()) {
                this.available.addAll(this.temporaryInFlight);
                this.temporaryInFlight.clear();
            }
        }
    }

    @Override
    public void acquire(boolean exclusiveConnection, ConnectionConsumer consumer) {
        HttpConnection connection = this.acquireNow(exclusiveConnection);
        if (connection != null) {
            consumer.accept(connection);
            this.checkCreateConnections();
        } else {
            if (this.failures > 100) {
                log.error("The request cannot be made since the failures to connect to {} exceeded a threshold. Stopping session.", (Object)this.authority);
                consumer.accept(null);
                return;
            }
            this.waiting.add(consumer);
            this.blockedSessions.incrementUsed();
        }
    }

    @Override
    public void afterRequestSent(HttpConnection connection) {
        if (connection.isAvailable()) {
            if (connection.inFlight() == 0) {
                this.available.addFirst(connection);
            } else {
                this.available.addLast(connection);
            }
        }
    }

    @Override
    public void release(HttpConnection connection, boolean becameAvailable, boolean afterRequest) {
        if (trace) {
            log.trace("Release {} (became available={} after request={})", (Object)connection, (Object)becameAvailable, (Object)afterRequest);
        }
        if (becameAvailable) {
            assert (!connection.isClosed());
            if (connection.inFlight() == 0) {
                this.available.addFirst(connection);
            } else {
                this.available.addLast(connection);
            }
        }
        if (afterRequest) {
            this.inFlight.decrementUsed();
        }
        if (connection.inFlight() == 0) {
            this.usedConnections.decrementUsed();
        }
        if (this.keepAliveFuture == null && this.sizeConfig.keepAliveTime() > 0L) {
            long lastUsed = this.available.stream().filter(c -> !c.isClosed()).mapToLong(HttpConnection::lastUsed).min().orElse(connection.lastUsed());
            long nextCheck = this.sizeConfig.keepAliveTime() - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - lastUsed);
            log.debug("Scheduling next keep-alive check in {} ms", (Object)nextCheck);
            this.keepAliveFuture = this.eventLoop.schedule(() -> {
                long now = System.nanoTime();
                for (HttpConnection c : this.available) {
                    long idleTime;
                    if (c.isClosed() || (idleTime = TimeUnit.NANOSECONDS.toMillis(now - c.lastUsed())) <= this.sizeConfig.keepAliveTime()) continue;
                    c.close();
                }
                this.keepAliveFuture = null;
            }, nextCheck, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void onSessionReset() {
    }

    @Override
    public int waitingSessions() {
        return this.waiting.size();
    }

    @Override
    public EventLoop executor() {
        return this.eventLoop;
    }

    @Override
    public void pulse() {
        ConnectionConsumer consumer;
        if (trace) {
            log.trace("Pulse to {} ({} waiting)", (Object)this.authority, (Object)this.waiting.size());
        }
        if ((consumer = this.waiting.poll()) != null) {
            HttpConnection connection = this.acquireNow(false);
            if (connection != null) {
                this.blockedSessions.decrementUsed();
                consumer.accept(connection);
            } else if (this.failures > 100) {
                log.error("The request cannot be made since the failures to connect to {} exceeded a threshold. Stopping session.", (Object)this.authority);
                consumer.accept(null);
            } else {
                this.waiting.addFirst(consumer);
            }
        }
        if (this.pulseFuture == null && !this.waiting.isEmpty()) {
            this.pulseFuture = this.executor().schedule(this::scheduledPulse, 1L, TimeUnit.MILLISECONDS);
        }
    }

    private Object scheduledPulse() {
        this.pulseFuture = null;
        this.pulse();
        return null;
    }

    public Collection<HttpConnection> connections() {
        return this.connections;
    }

    private void checkCreateConnections() {
        assert (this.eventLoop.inEventLoop());
        if (this.shutdown) {
            return;
        }
        if (this.failures > 100) {
            Handler<AsyncResult<Void>> handler = this.startedHandler;
            if (handler != null) {
                this.startedHandler = null;
                Object failureMessage = String.format("Cannot connect to %s: %d created, %d failures.", this.authority, this.created, this.failures);
                if (this.created > 0) {
                    failureMessage = (String)failureMessage + " Hint: either configure SUT to accept more open connections or reduce http.sharedConnections.";
                }
                handler.handle((Object)Future.failedFuture((String)failureMessage));
            }
            this.pulse();
            return;
        }
        if (this.needsMoreConnections()) {
            ++this.connecting;
            this.clientPool.connect(this, this.handleNewConnection);
            this.eventLoop.schedule(this.checkCreateConnections, 2L, TimeUnit.MILLISECONDS);
        }
    }

    private boolean needsMoreConnections() {
        return this.created + this.connecting < this.sizeConfig.core() || this.created + this.connecting < this.sizeConfig.max() && this.connecting + this.available.size() - this.availableClosed < this.sizeConfig.buffer();
    }

    private void handleNewConnection(HttpConnection conn, Throwable err) {
        if (err != null) {
            log.warn((Message)new FormattedMessage("Cannot create connection to {} (created: {}, failures: {})", new Object[]{this.authority, this.created, this.failures + 1}), err);
            if (!this.eventLoop.isShuttingDown() && !this.eventLoop.isShutdown()) {
                this.eventLoop.execute(this.onConnectFailure);
            }
        } else {
            assert (conn.context().executor() == this.eventLoop);
            assert (this.eventLoop.inEventLoop());
            Handler<AsyncResult<Void>> handler = null;
            this.connections.add(conn);
            --this.connecting;
            ++this.created;
            this.failures = 0;
            this.available.add(conn);
            log.debug("Created {} to {} ({}+{}=?{}:{}/{})", (Object)conn, (Object)this.authority, (Object)this.created, (Object)this.connecting, (Object)this.connections.size(), (Object)(this.available.size() - this.availableClosed), (Object)this.sizeConfig.max());
            this.incrementTypeStats(conn);
            conn.context().channel().closeFuture().addListener(v -> {
                conn.setClosed();
                log.debug("Closed {} to {}. ({}+{}=?{}:{}/{})", (Object)conn, (Object)this.authority, (Object)this.created, (Object)this.connecting, (Object)this.connections.size(), (Object)(this.available.size() - this.availableClosed), (Object)this.sizeConfig.max());
                --this.created;
                ++this.closed;
                if (this.available.contains(conn)) {
                    ++this.availableClosed;
                }
                ((Watermarks)this.typeStats.get(this.tagConnection(conn))).decrementUsed();
                if (!this.shutdown) {
                    if (this.closed >= this.sizeConfig.max()) {
                        this.connections.removeIf(Connection::isClosed);
                        this.closed = 0;
                    }
                    this.checkCreateConnections();
                }
            });
            if (this.needsMoreConnections()) {
                this.checkCreateConnections();
            } else if (this.startedHandler != null && this.created >= this.sizeConfig.core()) {
                handler = this.startedHandler;
                this.startedHandler = null;
            }
            if (handler != null) {
                handler.handle((Object)Future.succeededFuture());
            }
            this.pulse();
        }
    }

    private void onConnectFailure() {
        ++this.failures;
        --this.connecting;
        this.eventLoop.schedule(this.checkCreateConnections, 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void start(Handler<AsyncResult<Void>> handler) {
        this.startedHandler = handler;
        this.eventLoop.execute(this.checkCreateConnections);
    }

    @Override
    public void shutdown() {
        log.debug("Shutdown called");
        this.shutdown = true;
        if (this.eventLoop.isShutdown()) {
            return;
        }
        this.eventLoop.execute(() -> {
            log.debug("Closing all connections");
            for (HttpConnection conn : this.connections) {
                if (conn.isClosed()) continue;
                conn.context().writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
                conn.context().close();
                conn.context().flush();
            }
        });
    }
}

