/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.core.impl.ConnectionStatsConsumer;
import io.hyperfoil.http.api.ConnectionConsumer;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.netty.channel.EventLoop;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionConnectionPool
implements HttpConnectionPool {
    private static final Logger log = LogManager.getLogger(SessionConnectionPool.class);
    private static final boolean trace = log.isTraceEnabled();
    private final HttpConnectionPool shared;
    private final ArrayDeque<HttpConnection> available;
    private final ArrayList<HttpConnection> owned;

    public SessionConnectionPool(HttpConnectionPool shared, int capacity) {
        this.shared = shared;
        this.available = new ArrayDeque(capacity);
        this.owned = new ArrayList(capacity);
    }

    @Override
    public HttpClientPool clientPool() {
        return this.shared.clientPool();
    }

    @Override
    public void acquire(boolean exclusiveConnection, ConnectionConsumer consumer) {
        HttpConnection connection;
        assert (!exclusiveConnection);
        do {
            if ((connection = this.available.pollFirst()) != null) continue;
            this.shared.acquire(true, consumer);
            return;
        } while (connection.isClosed());
        this.shared.incrementInFlight();
        connection.onAcquire();
        consumer.accept(connection);
    }

    @Override
    public void afterRequestSent(HttpConnection connection) {
        if (connection.isAvailable()) {
            log.trace("Keeping connection in session-local pool {}.", (Object)connection);
            this.available.addLast(connection);
        }
        if (!this.owned.contains(connection)) {
            this.owned.add(connection);
        }
    }

    @Override
    public int waitingSessions() {
        return this.shared.waitingSessions();
    }

    @Override
    public EventLoop executor() {
        return this.shared.executor();
    }

    @Override
    public void pulse() {
        this.shared.pulse();
    }

    @Override
    public Collection<? extends HttpConnection> connections() {
        return this.available;
    }

    @Override
    public void release(HttpConnection connection, boolean becameAvailable, boolean afterRequest) {
        if (trace) {
            log.trace("Releasing to session-local pool {} ({}, {})", (Object)connection, (Object)becameAvailable, (Object)afterRequest);
        }
        if (becameAvailable) {
            log.trace("Added connection to session-local pool.");
            this.available.addLast(connection);
        }
        if (afterRequest) {
            if (connection.isOpen()) {
                this.shared.decrementInFlight();
            } else {
                this.shared.release(connection, becameAvailable, true);
                this.owned.remove(connection);
            }
        }
    }

    @Override
    public void onSessionReset() {
        for (int i = this.owned.size() - 1; i >= 0; --i) {
            HttpConnection connection = this.owned.get(i);
            if (connection.inFlight() == 0) {
                this.shared.release(connection, !connection.isClosed(), false);
                continue;
            }
            connection.close();
        }
        this.owned.clear();
        this.available.clear();
    }

    @Override
    public void incrementInFlight() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decrementInFlight() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitConnectionStats(ConnectionStatsConsumer consumer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void start(Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }
}

