/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.session.Session;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpDestinationTable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpDestinationTableImpl
implements HttpDestinationTable {
    private final Map<String, HttpConnectionPool> byAuthority;
    private final Map<String, HttpConnectionPool> byName;
    private final String[] authorities;
    private final byte[][] authorityBytes;

    public HttpDestinationTableImpl(Map<String, HttpConnectionPool> byAuthority) {
        this.byAuthority = byAuthority;
        this.byName = byAuthority.entrySet().stream().filter(entry -> entry.getKey() != null && ((HttpConnectionPool)entry.getValue()).clientPool().config().name() != null).collect(Collectors.toMap(entry -> ((HttpConnectionPool)entry.getValue()).clientPool().config().name(), Map.Entry::getValue));
        this.authorities = (String[])byAuthority.keySet().stream().filter(Objects::nonNull).toArray(String[]::new);
        this.authorityBytes = (byte[][])Stream.of(this.authorities).map(url -> url.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
    }

    public HttpDestinationTableImpl(HttpDestinationTable other, Function<HttpConnectionPool, HttpConnectionPool> replacePool) {
        this.authorities = other.authorities();
        this.authorityBytes = other.authorityBytes();
        this.byAuthority = new HashMap<String, HttpConnectionPool>();
        this.byName = new HashMap<String, HttpConnectionPool>();
        HttpConnectionPool defaultPool = other.getConnectionPoolByAuthority(null);
        for (String authority : this.authorities) {
            HttpConnectionPool pool = other.getConnectionPoolByAuthority(authority);
            HttpConnectionPool newPool = replacePool.apply(pool);
            this.byAuthority.put(authority, newPool);
            if (pool == defaultPool) {
                this.byAuthority.put(null, newPool);
            }
            this.byName.put(pool.clientPool().config().name(), newPool);
        }
    }

    @Override
    public String[] authorities() {
        return this.authorities;
    }

    @Override
    public byte[][] authorityBytes() {
        return this.authorityBytes;
    }

    public void onSessionReset(Session session) {
        this.byAuthority.values().forEach(HttpConnectionPool::onSessionReset);
    }

    @Override
    public boolean hasSingleDestination() {
        return this.authorities.length == 1;
    }

    @Override
    public HttpConnectionPool getConnectionPoolByName(String endpoint) {
        return this.byName.get(endpoint);
    }

    @Override
    public HttpConnectionPool getConnectionPoolByAuthority(String authority) {
        return this.byAuthority.get(authority);
    }

    public Iterable<Map.Entry<String, HttpConnectionPool>> iterable() {
        return this.byAuthority.entrySet();
    }
}

