/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.core.impl.ConnectionStatsConsumer;
import io.hyperfoil.core.impl.EventLoopFactory;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpVersion;
import io.hyperfoil.http.config.ConnectionPoolConfig;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.connection.ConnectionAllocator;
import io.hyperfoil.http.connection.ConnectionReceiver;
import io.hyperfoil.http.connection.HttpChannelInitializer;
import io.hyperfoil.http.connection.SharedConnectionPool;
import io.hyperfoil.impl.Util;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpClientPoolImpl
implements HttpClientPool {
    private static final Logger log = LogManager.getLogger(HttpClientPoolImpl.class);
    final Http http;
    final String[] addressHosts;
    final int[] addressPorts;
    final int port;
    final String host;
    final String scheme;
    final String authority;
    final byte[] originalDestinationBytes;
    final SslContext sslContext;
    final boolean forceH2c;
    private final HttpConnectionPool[] children;
    private final AtomicInteger idx = new AtomicInteger();
    private final Supplier<HttpConnectionPool> nextSupplier;

    public static HttpClientPoolImpl forTesting(Http http, int threads) throws SSLException {
        final EventLoopGroup eventLoopGroup = EventLoopFactory.INSTANCE.create(threads);
        EventLoop[] executors = (EventLoop[])StreamSupport.stream(eventLoopGroup.spliterator(), false).map(EventLoop.class::cast).toArray(EventLoop[]::new);
        return new HttpClientPoolImpl(http, executors, Benchmark.forTesting(), 0){

            @Override
            public void shutdown() {
                super.shutdown();
                eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.SECONDS);
            }
        };
    }

    public HttpClientPoolImpl(Http http, EventLoop[] executors, Benchmark benchmark, int agentId) throws SSLException {
        int bufferConnections;
        int maxConnections;
        int coreConnections;
        this.http = http;
        this.sslContext = http.protocol().secure() ? this.createSslContext() : null;
        this.host = http.host();
        this.port = http.port();
        this.scheme = this.sslContext == null ? "http" : "https";
        this.authority = this.host + ":" + this.port;
        this.originalDestinationBytes = http.originalDestination().getBytes(StandardCharsets.UTF_8);
        this.forceH2c = http.versions().length == 1 && http.versions()[0] == HttpVersion.HTTP_2_0;
        this.children = new HttpConnectionPool[executors.length];
        switch (http.connectionStrategy()) {
            case SHARED_POOL: 
            case SESSION_POOLS: {
                boolean hadBuffer;
                coreConnections = benchmark.slice(http.sharedConnections().core(), agentId);
                maxConnections = benchmark.slice(http.sharedConnections().max(), agentId);
                bufferConnections = benchmark.slice(http.sharedConnections().buffer(), agentId);
                boolean bl = hadBuffer = http.sharedConnections().buffer() > 0;
                if (coreConnections < executors.length || maxConnections < executors.length || hadBuffer && bufferConnections < executors.length) {
                    int prevCore = coreConnections;
                    int prevMax = maxConnections;
                    int prevBuffer = bufferConnections;
                    coreConnections = Math.max(coreConnections, executors.length);
                    maxConnections = Math.max(maxConnections, executors.length);
                    bufferConnections = Math.max(bufferConnections, hadBuffer ? executors.length : 0);
                    log.warn("Connection pool size (core {}, max {}, buffer {}) too small: the event loop has {} executors. Setting connection pool size to core {}, max {}, buffer {}", (Object)prevCore, (Object)prevMax, (Object)prevBuffer, (Object)executors.length, (Object)coreConnections, (Object)maxConnections, (Object)bufferConnections);
                }
                log.info("Allocating {} connections (max {}, buffer {}) in {} executors to {}", (Object)coreConnections, (Object)maxConnections, (Object)bufferConnections, (Object)executors.length, (Object)(http.protocol().scheme + "://" + this.authority));
                break;
            }
            case OPEN_ON_REQUEST: 
            case ALWAYS_NEW: {
                coreConnections = 0;
                maxConnections = 0;
                bufferConnections = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow connection strategy " + String.valueOf((Object)http.connectionStrategy()));
            }
        }
        int coreShare = coreConnections / executors.length;
        int maxShare = maxConnections / executors.length;
        int bufferShare = bufferConnections / executors.length;
        int coreRemainder = coreConnections - coreShare * executors.length;
        int maxRemainder = maxConnections - maxShare * executors.length;
        int bufferRemainder = bufferConnections - bufferShare * executors.length;
        for (int i = 0; i < executors.length; ++i) {
            if (maxConnections > 0) {
                int core = coreShare + (i < coreRemainder ? 1 : 0);
                int max = maxShare + (i < maxRemainder ? 1 : 0);
                int buffer = bufferShare + (i < bufferRemainder ? 1 : 0);
                this.children[i] = new SharedConnectionPool(this, executors[i], new ConnectionPoolConfig(core, max, buffer, http.sharedConnections().keepAliveTime()));
                continue;
            }
            this.children[i] = new ConnectionAllocator(this, executors[i]);
        }
        if (Integer.bitCount(this.children.length) == 1) {
            int shift = 32 - Integer.numberOfLeadingZeros(this.children.length - 1);
            int mask = (1 << shift) - 1;
            this.nextSupplier = () -> this.children[this.idx.getAndIncrement() & mask];
        } else {
            this.nextSupplier = () -> this.children[this.idx.getAndIncrement() % this.children.length];
        }
        this.addressHosts = new String[http.addresses().length];
        this.addressPorts = new int[http.addresses().length];
        String[] addresses = http.addresses();
        for (int i = 0; i < addresses.length; ++i) {
            String address = addresses[i];
            int bracketIndex = address.lastIndexOf(93);
            int firstColonIndex = address.indexOf(58);
            int lastColonIndex = address.lastIndexOf(58);
            if (lastColonIndex >= 0 && (bracketIndex >= 0 && lastColonIndex > bracketIndex || bracketIndex < 0 && lastColonIndex == firstColonIndex)) {
                this.addressHosts[i] = address.substring(0, lastColonIndex);
                this.addressPorts[i] = (int)Util.parseLong((CharSequence)address, (int)(lastColonIndex + 1), (int)address.length(), (long)this.port);
                continue;
            }
            this.addressHosts[i] = address;
            this.addressPorts[i] = this.port;
        }
    }

    private SslContext createSslContext() throws SSLException {
        SslProvider provider = SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK;
        TrustManagerFactory trustManagerFactory = this.createTrustManagerFactory();
        SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(trustManagerFactory).keyManager(this.createKeyManagerFactory());
        builder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (String[])Stream.of(this.http.versions()).map(HttpVersion::protocolName).toArray(String[]::new)));
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyManagerFactory createKeyManagerFactory() {
        Http.KeyManager config = this.http.keyManager();
        if (config.storeBytes() == null && config.certBytes() == null && config.keyBytes() == null) {
            return null;
        }
        try {
            KeyStore ks = KeyStore.getInstance(config.storeType());
            if (config.storeBytes() != null) {
                ks.load(new ByteArrayInputStream(config.storeBytes()), config.password() == null ? null : config.password().toCharArray());
                if (config.alias() != null) {
                    if (!ks.containsAlias(config.alias()) || !ks.isKeyEntry(config.alias())) throw new BenchmarkDefinitionException("Store file " + String.valueOf(config.storeBytes()) + " does not contain any entry for alias " + config.alias());
                    KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(config.password().toCharArray());
                    KeyStore.Entry entry = ks.getEntry(config.alias(), password);
                    ks = KeyStore.getInstance(config.storeType());
                    ks.load(null);
                    ks.setEntry(config.alias(), entry, password);
                }
            } else {
                ks.load(null, null);
            }
            if (config.certBytes() != null || config.keyBytes() != null) {
                if (config.certBytes() == null || config.keyBytes() == null) {
                    throw new BenchmarkDefinitionException("You should provide both certificate and private key for " + this.http.host() + ":" + this.http.port());
                }
                ks.setKeyEntry(config.alias() == null ? "default" : config.alias(), this.toPrivateKey(config.keyBytes()), config.password().toCharArray(), new Certificate[]{HttpClientPoolImpl.loadCertificate(config.certBytes())});
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(ks, config.password().toCharArray());
            return keyManagerFactory;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new BenchmarkDefinitionException("Cannot create key manager for " + this.http.host() + ":" + this.http.port(), (Throwable)e);
        }
    }

    private PrivateKey toPrivateKey(byte[] bytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        int pos;
        int lastPos = bytes.length - 1;
        for (pos = 0; pos < bytes.length && this.isWhite(bytes[pos]); ++pos) {
        }
        while (pos < bytes.length && bytes[pos] != 10) {
            ++pos;
        }
        while (lastPos >= 0 && this.isWhite(bytes[lastPos])) {
            --lastPos;
        }
        while (lastPos >= 0 && bytes[lastPos] != 10) {
            --lastPos;
        }
        ByteBuffer buffer = ByteBuffer.allocate(lastPos - pos);
        while (pos < lastPos) {
            if (!this.isWhite(bytes[pos])) {
                buffer.put(bytes[pos]);
            }
            ++pos;
        }
        buffer.flip();
        ByteBuffer rawBuffer = Base64.getDecoder().decode(buffer);
        byte[] decoded = new byte[rawBuffer.limit()];
        rawBuffer.get(decoded);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decoded);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    private boolean isWhite(byte b) {
        return b == 32 || b == 10 || b == 13;
    }

    private TrustManagerFactory createTrustManagerFactory() {
        Http.TrustManager config = this.http.trustManager();
        if (config.storeBytes() == null && config.certBytes() == null) {
            return InsecureTrustManagerFactory.INSTANCE;
        }
        try {
            KeyStore ks = KeyStore.getInstance(config.storeType());
            if (config.storeBytes() != null) {
                ks.load(new ByteArrayInputStream(config.storeBytes()), config.password() == null ? null : config.password().toCharArray());
            } else {
                ks.load(null, null);
            }
            if (config.certBytes() != null) {
                ks.setCertificateEntry("default", HttpClientPoolImpl.loadCertificate(config.certBytes()));
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(ks);
            return trustManagerFactory;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new BenchmarkDefinitionException("Cannot create trust manager for " + this.http.host() + ":" + this.http.port(), (Throwable)e);
        }
    }

    private static Certificate loadCertificate(byte[] bytes) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertificate(new ByteArrayInputStream(bytes));
    }

    @Override
    public Http config() {
        return this.http;
    }

    @Override
    public void start(Handler<AsyncResult<Void>> completionHandler) {
        AtomicInteger countDown = new AtomicInteger(this.children.length);
        for (HttpConnectionPool child : this.children) {
            child.start((Handler<AsyncResult<Void>>)((Handler)result -> {
                if (result.failed() || countDown.decrementAndGet() == 0) {
                    if (result.failed()) {
                        this.shutdown();
                    }
                    completionHandler.handle(result);
                }
            }));
        }
    }

    @Override
    public void shutdown() {
        for (HttpConnectionPool child : this.children) {
            child.shutdown();
        }
    }

    void connect(HttpConnectionPool pool, ConnectionReceiver handler) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.channel(EventLoopFactory.INSTANCE.socketChannel());
        bootstrap.group((EventLoopGroup)pool.executor());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        bootstrap.handler((ChannelHandler)new HttpChannelInitializer(this, handler));
        String address = this.host;
        int port = this.port;
        if (this.addressHosts.length > 0) {
            int index = ThreadLocalRandom.current().nextInt(this.addressHosts.length);
            address = this.addressHosts[index];
            port = this.addressPorts[index];
        }
        ChannelFuture fut = bootstrap.connect((SocketAddress)new InetSocketAddress(address, port));
        fut.addListener((GenericFutureListener)handler);
    }

    @Override
    public HttpConnectionPool next() {
        return this.nextSupplier.get();
    }

    @Override
    public HttpConnectionPool connectionPool(EventExecutor executor) {
        for (HttpConnectionPool pool : this.children) {
            if (pool.executor() != executor) continue;
            return pool;
        }
        throw new IllegalStateException();
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public String authority() {
        return this.authority;
    }

    @Override
    public byte[] originalDestinationBytes() {
        return this.originalDestinationBytes;
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public boolean isSecure() {
        return this.sslContext != null;
    }

    @Override
    public void visitConnectionStats(ConnectionStatsConsumer consumer) {
        for (HttpConnectionPool pool : this.children) {
            pool.visitConnectionStats(consumer);
        }
    }
}

