/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.connection.CustomHttp2ConnectionHandler;
import io.hyperfoil.http.connection.Http1xConnection;
import io.hyperfoil.http.connection.Http1xResponseHandler;
import io.hyperfoil.http.connection.Http2ConnectionHandlerBuilder;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.hyperfoil.http.connection.RawRequestHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslMasterKeyHandler;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.util.function.BiConsumer;

class HttpChannelInitializer
extends ChannelInitializer<Channel> {
    private final HttpClientPoolImpl clientPool;
    private final BiConsumer<HttpConnection, Throwable> handler;
    private final Http2ConnectionHandlerBuilder http2ConnectionHandlerBuilder;
    private final ApplicationProtocolNegotiationHandler alpnHandler = new ApplicationProtocolNegotiationHandler("http/1.1"){

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            ChannelPipeline p = ctx.pipeline();
            if ("h2".equals(protocol)) {
                DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
                CustomHttp2ConnectionHandler clientHandler = HttpChannelInitializer.this.http2ConnectionHandlerBuilder.build((Http2Connection)connection);
                p.addLast(new ChannelHandler[]{clientHandler});
            } else if ("http/1.1".equals(protocol)) {
                HttpChannelInitializer.this.initHttp1xConnection(p);
            } else {
                ctx.close();
                throw new IllegalStateException("unknown protocol: " + protocol);
            }
        }

        protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            HttpChannelInitializer.this.handler.accept(null, new IOException("TLS handshake failure", cause));
            ctx.close();
        }
    };

    HttpChannelInitializer(HttpClientPoolImpl clientPool, BiConsumer<HttpConnection, Throwable> handler) {
        this.clientPool = clientPool;
        this.handler = handler;
        this.http2ConnectionHandlerBuilder = new Http2ConnectionHandlerBuilder(clientPool, clientPool.sslContext == null, handler);
    }

    protected void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.clientPool.sslContext != null) {
            long sslHandshakeTimeout;
            boolean logMasterKey = SystemPropertyUtil.getBoolean((String)"io.netty.ssl.masterKeyHandler", (boolean)false);
            SslHandler sslHandler = this.clientPool.sslContext.newHandler(ch.alloc(), this.clientPool.host, this.clientPool.port);
            if (logMasterKey) {
                sslHandler.engine().setEnabledProtocols(new String[]{"TLSv1.2"});
            }
            sslHandler.setHandshakeTimeoutMillis((sslHandshakeTimeout = this.clientPool.config().sslHandshakeTimeout()) < 0L ? 0L : sslHandshakeTimeout);
            sslHandler.handshakeFuture().addListener(future -> {
                if (!future.isSuccess()) {
                    this.handler.accept(null, new IOException("SSL handshake failure", future.cause()));
                }
            });
            pipeline.addLast(new ChannelHandler[]{sslHandler});
            pipeline.addLast(new ChannelHandler[]{this.alpnHandler});
            if (logMasterKey) {
                pipeline.addLast(new ChannelHandler[]{SslMasterKeyHandler.newWireSharkSslMasterKeyHandler()});
            }
        } else if (this.clientPool.forceH2c) {
            DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
            CustomHttp2ConnectionHandler clientHandler = this.http2ConnectionHandlerBuilder.build((Http2Connection)connection);
            HttpClientCodec sourceCodec = new HttpClientCodec();
            Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)clientHandler);
            HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
            ChannelInboundHandlerAdapter upgradeRequestHandler = new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
                    upgradeRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)HttpChannelInitializer.this.clientPool.config().originalDestination());
                    ctx.writeAndFlush((Object)upgradeRequest);
                    ctx.fireChannelActive();
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            };
            pipeline.addLast(new ChannelHandler[]{sourceCodec, upgradeHandler, upgradeRequestHandler});
        } else {
            this.initHttp1xConnection(pipeline);
        }
    }

    private void initHttp1xConnection(ChannelPipeline pipeline) {
        Http1xConnection connection = new Http1xConnection(this.clientPool, this.handler);
        if (this.clientPool.http.rawBytesHandlers()) {
            pipeline.addLast(new ChannelHandler[]{new Http1xResponseHandler(connection)});
            pipeline.addLast(new ChannelHandler[]{new RawRequestHandler(connection)});
        }
        pipeline.addLast("handler", (ChannelHandler)connection);
    }
}

