/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.connection.CustomHttp2ConnectionHandler;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Settings;
import java.util.function.BiConsumer;

class Http2ConnectionHandlerBuilder
extends AbstractHttp2ConnectionHandlerBuilder<CustomHttp2ConnectionHandler, Http2ConnectionHandlerBuilder> {
    private final HttpClientPool clientPool;
    private final boolean isUpgrade;
    private final BiConsumer<HttpConnection, Throwable> requestHandler;

    Http2ConnectionHandlerBuilder(HttpClientPool clientPool, boolean isUpgrade, BiConsumer<HttpConnection, Throwable> requestHandler) {
        this.clientPool = clientPool;
        this.isUpgrade = isUpgrade;
        this.requestHandler = requestHandler;
    }

    protected CustomHttp2ConnectionHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        return new CustomHttp2ConnectionHandler(this.clientPool, this.requestHandler, decoder, encoder, initialSettings, this.isUpgrade);
    }

    public CustomHttp2ConnectionHandler build(Http2Connection conn) {
        this.connection(conn);
        this.frameListener((Http2FrameListener)new Http2EventAdapter(this){});
        return (CustomHttp2ConnectionHandler)super.build();
    }
}

