/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.core.util.Watermarks;
import io.hyperfoil.http.api.ConnectionConsumer;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.connection.ConnectionPoolStats;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.netty.channel.EventLoop;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.Collection;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ConnectionAllocator
extends ConnectionPoolStats
implements HttpConnectionPool {
    private static final Logger log = LogManager.getLogger(ConnectionAllocator.class);
    private final HttpClientPoolImpl clientPool;
    private final EventLoop eventLoop;

    ConnectionAllocator(HttpClientPoolImpl clientPool, EventLoop eventLoop) {
        super(clientPool.authority);
        this.clientPool = clientPool;
        this.eventLoop = eventLoop;
    }

    @Override
    public HttpClientPool clientPool() {
        return this.clientPool;
    }

    @Override
    public void acquire(boolean exclusiveConnection, ConnectionConsumer consumer) {
        log.trace("Creating connection to {}", (Object)this.authority);
        this.blockedSessions.incrementUsed();
        this.clientPool.connect(this, (conn, err) -> {
            if (err != null) {
                log.error("Cannot create connection to " + this.authority, err);
                this.blockedSessions.decrementUsed();
                consumer.accept(null);
            } else {
                log.debug("Created {} to {}", conn, (Object)this.authority);
                this.blockedSessions.decrementUsed();
                this.inFlight.incrementUsed();
                this.usedConnections.incrementUsed();
                this.incrementTypeStats((HttpConnection)conn);
                conn.onAcquire();
                conn.context().channel().closeFuture().addListener(v -> {
                    conn.setClosed();
                    log.debug("Closed {} to {}", conn, (Object)this.authority);
                    ((Watermarks)this.typeStats.get(this.tagConnection((HttpConnection)conn))).decrementUsed();
                    this.usedConnections.decrementUsed();
                });
                consumer.accept((HttpConnection)conn);
            }
        });
    }

    @Override
    public void afterRequestSent(HttpConnection connection) {
    }

    @Override
    public int waitingSessions() {
        return this.blockedSessions.current();
    }

    @Override
    public EventLoop executor() {
        return this.eventLoop;
    }

    @Override
    public void pulse() {
    }

    @Override
    public Collection<? extends HttpConnection> connections() {
        return Collections.emptyList();
    }

    @Override
    public void release(HttpConnection connection, boolean becameAvailable, boolean afterRequest) {
        if (afterRequest) {
            this.decrementInFlight();
        }
        connection.close();
    }

    @Override
    public void onSessionReset() {
    }

    @Override
    public void start(Handler<AsyncResult<Void>> handler) {
        handler.handle((Object)Future.succeededFuture());
    }

    @Override
    public void shutdown() {
    }
}

