/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

public abstract class BaseResponseHandler
extends ChannelInboundHandlerAdapter {
    protected final HttpConnection connection;
    protected int responseBytes = 0;

    public BaseResponseHandler(HttpConnection connection) {
        this.connection = connection;
    }

    protected boolean handleBuffer(ChannelHandlerContext ctx, ByteBuf buf, int streamId) throws Exception {
        boolean isLastPart;
        HttpRequest request = null;
        if (this.isRequestStream(streamId)) {
            request = this.connection.peekRequest(streamId);
        }
        if (buf.readableBytes() > this.responseBytes) {
            ByteBuf slice = buf.readRetainedSlice(this.responseBytes);
            this.onRawData(request, slice, true);
            this.onCompletion(request);
            this.onData(ctx, slice);
            this.responseBytes = 0;
            return true;
        }
        boolean bl = isLastPart = buf.readableBytes() == this.responseBytes;
        if (request != null) {
            this.onRawData(request, buf, isLastPart);
        }
        this.responseBytes -= buf.readableBytes();
        if (isLastPart && request != null) {
            this.onCompletion(request);
        }
        this.onData(ctx, buf);
        return false;
    }

    protected abstract boolean isRequestStream(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRawData(HttpRequest request, ByteBuf data, boolean isLastPart) {
        if (request != null && !request.isCompleted()) {
            int readerIndex = data.readerIndex();
            HttpResponseHandlers handlers = request.handlers();
            request.enter();
            try {
                handlers.handleRawResponse(request, data, data.readerIndex(), data.readableBytes(), isLastPart);
            }
            finally {
                request.exit();
            }
            request.session.proceed();
            if (data.readerIndex() != readerIndex) {
                throw new IllegalStateException("Handler has changed readerIndex on the buffer!");
            }
        }
    }

    protected void onData(ChannelHandlerContext ctx, ByteBuf buf) {
        ctx.fireChannelRead((Object)buf);
    }

    protected void onStatus(int status) {
    }

    protected void onHeaderRead(ByteBuf buf, int startOfName, int endOfName, int startOfValue, int endOfValue) {
    }

    protected void onBodyPart(ByteBuf buf, int startOffset, int length, boolean isLastPart) {
    }

    protected void onCompletion(HttpRequest request) {
    }
}

