/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.config;

import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.PluginBuilder;
import io.hyperfoil.api.config.PluginConfig;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.config.HttpErgonomics;
import io.hyperfoil.http.config.HttpPluginConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class HttpPluginBuilder
extends PluginBuilder<HttpErgonomics> {
    private HttpBuilder defaultHttp;
    private final List<HttpBuilder> httpList = new ArrayList<HttpBuilder>();
    private final HttpErgonomics ergonomics = new HttpErgonomics(this);

    public HttpPluginBuilder(BenchmarkBuilder parent) {
        super(parent);
    }

    public static Collection<HttpBuilder> httpForTesting(BenchmarkBuilder benchmarkBuilder) {
        HttpPluginBuilder builder = (HttpPluginBuilder)benchmarkBuilder.plugin(HttpPluginBuilder.class);
        if (builder.defaultHttp == null) {
            return Collections.unmodifiableList(builder.httpList);
        }
        if (builder.httpList.isEmpty()) {
            return Collections.singletonList(builder.defaultHttp);
        }
        ArrayList<HttpBuilder> list = new ArrayList<HttpBuilder>(builder.httpList);
        list.add(builder.defaultHttp);
        return list;
    }

    public HttpBuilder http() {
        if (this.defaultHttp == null) {
            this.defaultHttp = new HttpBuilder(this);
        }
        return this.defaultHttp;
    }

    public HttpBuilder http(String host) {
        HttpBuilder builder = new HttpBuilder(this).host(host);
        this.httpList.add(builder);
        return builder;
    }

    public HttpErgonomics ergonomics() {
        return this.ergonomics;
    }

    public void prepareBuild() {
        if (this.defaultHttp == null) {
            if (this.httpList.isEmpty()) {
                throw new BenchmarkDefinitionException("No default HTTP target set!");
            }
            if (this.httpList.size() == 1) {
                this.defaultHttp = this.httpList.iterator().next();
            }
        } else {
            if (this.httpList.stream().anyMatch(http -> http.authority().equals(this.defaultHttp.authority()))) {
                throw new BenchmarkDefinitionException("Ambiguous HTTP definition for " + this.defaultHttp.authority() + ": defined both as default and non-default");
            }
            this.httpList.add(this.defaultHttp);
        }
        this.httpList.forEach(HttpBuilder::prepareBuild);
    }

    public void addTags(Map<String, Object> tags) {
        if (this.defaultHttp != null) {
            Http defaultHttp = this.defaultHttp.build(true);
            tags.put("url", defaultHttp.protocol().scheme + "://" + defaultHttp.host() + ":" + defaultHttp.port());
            tags.put("protocol", defaultHttp.protocol().scheme);
        }
    }

    public PluginConfig build() {
        HashMap<String, Http> byName = new HashMap<String, Http>();
        HashMap<String, Http> byAuthority = new HashMap<String, Http>();
        Iterator<HttpBuilder> iterator = this.httpList.iterator();
        while (iterator.hasNext()) {
            Http previous;
            HttpBuilder builder;
            Http http = builder.build((builder = iterator.next()) == this.defaultHttp);
            Http http2 = previous = builder.name() == null ? null : byName.put(builder.name(), http);
            if (previous != null) {
                throw new BenchmarkDefinitionException("Duplicate HTTP endpoint name " + builder.name() + ": used both for " + http.originalDestination() + " and " + previous.originalDestination());
            }
            previous = byAuthority.put(builder.authority(), http);
            if (previous == null || builder.name() != null) continue;
            throw new BenchmarkDefinitionException("Duplicate HTTP endpoint for authority " + builder.authority());
        }
        return new HttpPluginConfig(byAuthority);
    }

    public boolean validateAuthority(String authority) {
        if (authority == null) {
            return this.defaultHttp != null;
        }
        return this.isValidAuthority(authority);
    }

    private boolean isValidAuthority(String authority) {
        long matches = this.httpList.stream().filter(HttpPluginBuilder.distinctByKey(http -> String.valueOf((Object)http.protocol()) + http.authority())).filter(http -> HttpPluginBuilder.compareAuthorities(http, authority)).count();
        return matches == 1L;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private static boolean compareAuthorities(HttpBuilder http, String authority) {
        StringBuilder auth1 = new StringBuilder(http.authority());
        StringBuilder auth2 = new StringBuilder(authority);
        if (!http.authority().contains(":")) {
            auth1.append(":").append(http.portOrDefault());
        }
        if (!authority.contains(":")) {
            auth2.append(":").append(http.portOrDefault());
        }
        return auth1.toString().equals(auth2.toString());
    }

    public boolean validateEndpoint(String endpoint) {
        return this.httpList.stream().anyMatch(http -> endpoint.equals(http.name()));
    }

    public HttpBuilder getHttp(String authority) {
        if (authority == null && this.defaultHttp != null) {
            return this.defaultHttp;
        }
        return this.httpList.stream().filter(http -> http.authority().equals(authority)).findFirst().orElse(null);
    }

    public HttpBuilder getHttpByName(String endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException();
        }
        return this.httpList.stream().filter(http -> http.name().equals(endpoint)).findFirst().orElse(null);
    }

    public HttpBuilder decoupledHttp() {
        return new HttpBuilder(this);
    }

    public void addHttp(HttpBuilder builder) {
        if (builder.authority() == null) {
            throw new BenchmarkDefinitionException("Missing hostname!");
        }
        this.httpList.add(builder);
    }
}

