/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.config;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.http.config.HttpBuilder;
import java.io.Serializable;

public class ConnectionPoolConfig
implements Serializable {
    private final int core;
    private final int max;
    private final int buffer;
    private final long keepAliveTime;

    public ConnectionPoolConfig(int core, int max, int buffer, long keepAliveTime) {
        this.core = core;
        this.max = max;
        this.buffer = buffer;
        this.keepAliveTime = keepAliveTime;
    }

    public int core() {
        return this.core;
    }

    public int max() {
        return this.max;
    }

    public int buffer() {
        return this.buffer;
    }

    public long keepAliveTime() {
        return this.keepAliveTime;
    }

    public static class Builder
    implements BuilderBase<Builder> {
        private final HttpBuilder parent;
        private int core;
        private int max;
        private int buffer;
        private long keepAliveTime;

        public Builder(HttpBuilder parent) {
            this.parent = parent;
        }

        public Builder core(int core) {
            this.core = core;
            return this;
        }

        public Builder max(int max) {
            this.max = max;
            return this;
        }

        public Builder buffer(int buffer) {
            this.buffer = buffer;
            return this;
        }

        public Builder keepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        public ConnectionPoolConfig build() {
            if (this.core < 0) {
                throw new BenchmarkDefinitionException("Illegal value for 'core': " + this.core + " (must be >= 0)");
            }
            if (this.max < 0) {
                throw new BenchmarkDefinitionException("Illegal value for 'max': " + this.max + " (must be >= 0)");
            }
            if (this.buffer < 0) {
                throw new BenchmarkDefinitionException("Illegal value for 'buffer': " + this.buffer + " (must be >= 0)");
            }
            if (this.core > this.max) {
                throw new BenchmarkDefinitionException("'core' > 'max': " + this.core + " > " + this.max);
            }
            if (this.buffer > this.max) {
                throw new BenchmarkDefinitionException("'buffer' > 'max': " + this.buffer + " > " + this.max);
            }
            return new ConnectionPoolConfig(this.core, this.max, this.buffer, this.keepAliveTime);
        }

        public HttpBuilder end() {
            return this.parent;
        }
    }
}

