/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.api;

import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SessionStopException;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.api.CacheControl;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.statistics.HttpStats;
import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class HttpRequest
extends Request {
    public static final Logger log = LogManager.getLogger(HttpRequest.class);
    public HttpResponseHandlers handlers;
    public HttpMethod method;
    public String authority;
    public String path;
    public final CacheControl cacheControl;
    private HttpConnectionPool pool;

    public HttpRequest(Session session, boolean httpCacheEnabled) {
        super(session);
        this.cacheControl = httpCacheEnabled ? new CacheControl() : null;
    }

    public static HttpRequest ensure(Request request) {
        if (request instanceof HttpRequest) {
            return (HttpRequest)request;
        }
        log.error("#{}: Expected HttpRequest, got {}", (Object)request.session.uniqueId(), (Object)request);
        return null;
    }

    public void start(HttpConnectionPool pool, HttpResponseHandlers handlers, SequenceInstance sequence, Statistics statistics) {
        this.handlers = handlers;
        this.pool = pool;
        this.start(sequence, statistics);
    }

    public void send(HttpConnection connection, BiConsumer<Session, HttpRequestWriter>[] headerAppenders, boolean injectHostHeader, BiFunction<Session, Connection, ByteBuf> bodyGenerator) {
        if (this.session.currentRequest() != null) {
            throw new IllegalStateException(String.format("#%d Invoking request directly from a request handler; current: %s, requested %s", new Object[]{this.session.uniqueId(), this.session.currentRequest(), this}));
        }
        this.attach(connection);
        connection.attach(this.pool);
        connection.request(this, headerAppenders, injectHostHeader, bodyGenerator);
    }

    public HttpConnection connection() {
        return (HttpConnection)super.connection();
    }

    public void setCompleted() {
        super.setCompleted();
        this.handlers = null;
        this.method = null;
        this.authority = null;
        this.path = null;
        this.pool = null;
        if (this.cacheControl != null) {
            this.cacheControl.reset();
        }
    }

    public HttpResponseHandlers handlers() {
        return this.handlers;
    }

    public String toString() {
        return super.toString() + " " + String.valueOf((Object)this.method) + " " + this.authority + this.path;
    }

    public void release() {
        if (this.status() != Request.Status.IDLE) {
            HttpRequestPool.get(this.session).release((Object)this);
            this.setIdle();
        }
    }

    public void handleCached() {
        HttpStats.addCacheHit(this.statistics(), this.startTimestampMillis());
        this.enter();
        try {
            this.handlers.handleEnd(this, false);
        }
        catch (SessionStopException sessionStopException) {
        }
        finally {
            this.exit();
            this.release();
        }
        this.session.proceed();
    }

    public void cancel(Throwable cause) {
        if (this.isRunning()) {
            this.enter();
            try {
                this.handlers.handleThrowable(this, cause);
            }
            catch (SessionStopException sessionStopException) {
            }
            catch (Exception e) {
                log.error((Message)new FormattedMessage("{} {} threw an exception when cancelling", (Object)this.session.uniqueId(), (Object)this), (Throwable)e);
            }
            finally {
                this.exit();
                this.release();
            }
            this.session.proceed();
        }
    }

    public boolean hasCacheControl() {
        return this.cacheControl != null;
    }
}

