/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.collection.LimitedPool;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.data.LimitedPoolResource;
import io.hyperfoil.http.api.HttpRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpRequestPool
extends LimitedPoolResource<HttpRequest> {
    private static final Logger log = LogManager.getLogger(HttpRequestPool.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final Session.ResourceKey<LimitedPoolResource<HttpRequest>> KEY = new LimitedPoolResource.Key();

    public HttpRequestPool(Scenario scenario, Session session, boolean httpCacheEnabled) {
        super(scenario.maxRequests(), HttpRequest.class, () -> new HttpRequest(session, httpCacheEnabled));
    }

    public static LimitedPool<HttpRequest> get(Session session) {
        return (LimitedPool)session.getResource(KEY);
    }

    public void onSessionReset(Session session) {
        if (!this.isFull()) {
            for (HttpRequest request : (HttpRequest[])this.originalObjects) {
                if (request.isCompleted() || !request.isValid()) continue;
                log.warn("#{} Session completed with requests in-flight!", (Object)session.uniqueId());
                break;
            }
            this.cancelRequests();
        }
        super.onSessionReset(session);
    }

    private void cancelRequests() {
        for (HttpRequest request : (HttpRequest[])this.originalObjects) {
            if (request.isCompleted()) continue;
            if (!request.isValid()) {
                request.statistics().addInvalid(request.startTimestampMillis());
            }
            if (trace) {
                log.trace("Canceling request {} to {}", (Object)request, (Object)request.connection());
            }
            request.setCompleting();
            if (request.connection() != null) {
                request.connection().close();
            }
            if (request.isCompleted()) continue;
            log.trace("#{} Connection close did not complete the request.", (Object)(request.session != null ? request.session.uniqueId() : 0));
            request.setCompleted();
            request.release();
        }
    }
}

