/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.internal;

import java.util.function.Function;

public interface Properties {
    public static final String HYPERFOIL_STACKTRACE = "io.hyperfoil.stacktrace";
    public static final String AGENT_DEBUG_PORT = "io.hyperfoil.agent.debug.port";
    public static final String AGENT_DEBUG_SUSPEND = "io.hyperfoil.agent.debug.suspend";
    public static final String AGENT_JAVA_EXECUTABLE = "io.hyperfoil.agent.java.executable";
    public static final String AGENT_NAME = "io.hyperfoil.agent.name";
    public static final String BENCHMARK_DIR = "io.hyperfoil.benchmarkdir";
    public static final String CONTROLLER_CLUSTER_IP = "io.hyperfoil.controller.cluster.ip";
    public static final String CONTROLLER_CLUSTER_PORT = "io.hyperfoil.controller.cluster.port";
    public static final String CONTROLLER_EXTERNAL_URI = "io.hyperfoil.controller.external.uri";
    public static final String CONTROLLER_HOST = "io.hyperfoil.controller.host";
    public static final String CONTROLLER_KEYSTORE_PATH = "io.hyperfoil.controller.keystore.path";
    public static final String CONTROLLER_KEYSTORE_PASSWORD = "io.hyperfoil.controller.keystore.password";
    public static final String CONTROLLER_PEM_KEYS = "io.hyperfoil.controller.pem.keys";
    public static final String CONTROLLER_PEM_CERTS = "io.hyperfoil.controller.pem.certs";
    public static final String CONTROLLER_SECURED_VIA_PROXY = "io.hyperfoil.controller.secured.via.proxy";
    public static final String CONTROLLER_PASSWORD = "io.hyperfoil.controller.password";
    public static final String CONTROLLER_LOG = "io.hyperfoil.controller.log.file";
    public static final String CONTROLLER_LOG_LEVEL = "io.hyperfoil.controller.log.level";
    public static final String CONTROLLER_PORT = "io.hyperfoil.controller.port";
    public static final String CPU_WATCHDOG_PERIOD = "io.hyperfoil.cpu.watchdog.period";
    public static final String CPU_WATCHDOG_IDLE_THRESHOLD = "io.hyperfoil.cpu.watchdog.idle.threshold";
    public static final String DEPLOYER = "io.hyperfoil.deployer";
    public static final String DEPLOY_TIMEOUT = "io.hyperfoil.deploy.timeout";
    public static final String DIST_DIR = "io.hyperfoil.distdir";
    public static final String JITTER_WATCHDOG_PERIOD = "io.hyperfoil.jitter.watchdog.period";
    public static final String JITTER_WATCHDOG_THRESHOLD = "io.hyperfoil.jitter.watchdog.threshold";
    public static final String LOG4J2_CONFIGURATION_FILE = "log4j.configurationFile";
    public static final String LOAD_DIR = "io.hyperfoil.loaddir";
    public static final String MAX_IN_MEMORY_RUNS = "io.hyperfoil.max.in.memory.runs";
    public static final String NETTY_TRANSPORT = "io.hyperfoil.netty.transport";
    public static final String ROOT_DIR = "io.hyperfoil.rootdir";
    public static final String RUN_DIR = "io.hyperfoil.rundir";
    public static final String RUN_ID = "io.hyperfoil.runid";
    public static final String TRIGGER_URL = "io.hyperfoil.trigger.url";
    public static final String CLI_REQUEST_TIMEOUT = "io.hyperfoil.cli.request.timeout";
    public static final String GC_CHECK = "io.hyperfoil.gc.check.enabled";
    public static final String CLUSTER_JGROUPS_STACK = "io.hyperfoil.cluster.jgroups_stack";
    public static final String REPORT_TEMPLATE = "io.hyperfoil.report.template";

    public static String get(String property, String def) {
        return Properties.get(property, Function.identity(), def);
    }

    public static long getLong(String property, long def) {
        return Properties.get(property, Long::valueOf, def);
    }

    public static int getInt(String property, int def) {
        return Properties.get(property, Integer::valueOf, def);
    }

    public static boolean getBoolean(String property) {
        return Properties.get(property, Boolean::valueOf, false);
    }

    public static <T> T get(String property, Function<String, T> f, T def) {
        String value = System.getProperty(property);
        if (value != null) {
            return f.apply(value);
        }
        value = System.getenv(property.replaceAll("[^a-zA-Z0-9]", "_").toUpperCase());
        if (value != null) {
            return f.apply(value);
        }
        return def;
    }
}

