/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.hyperfoil.api.statistics.StatsExtension;
import java.io.PrintWriter;
import java.util.SortedMap;

public class StatisticsSummary {
    public final long startTime;
    public final long endTime;
    public final long minResponseTime;
    public final long meanResponseTime;
    public final long stdDevResponseTime;
    public final long maxResponseTime;
    public final SortedMap<Double, Long> percentileResponseTime;
    public final int requestCount;
    public final int responseCount;
    public final int invalid;
    public final int connectionErrors;
    public final int requestTimeouts;
    public final int internalErrors;
    public final long blockedTime;
    public final SortedMap<String, StatsExtension> extensions;

    @JsonCreator
    public StatisticsSummary(@JsonProperty(value="startTime") long startTime, @JsonProperty(value="endTime") long endTime, @JsonProperty(value="minResponseTime") long minResponseTime, @JsonProperty(value="meanResponseTime") long meanResponseTime, @JsonProperty(value="stdDevResponseTime") long stdDevResponseTime, @JsonProperty(value="maxResponseTime") long maxResponseTime, @JsonProperty(value="percentileResponseTime") SortedMap<Double, Long> percentileResponseTime, @JsonProperty(value="requestCount") int requestCount, @JsonProperty(value="responseCount") int responseCount, @JsonProperty(value="invalid") int invalid, @JsonProperty(value="connectionErrors") int connectionErrors, @JsonProperty(value="requestTimeouts") int requestTimeouts, @JsonProperty(value="internalErrors") int internalErrors, @JsonProperty(value="blockedTime") long blockedTime, @JsonProperty(value="extensions") SortedMap<String, StatsExtension> extensions) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.minResponseTime = minResponseTime;
        this.meanResponseTime = meanResponseTime;
        this.stdDevResponseTime = stdDevResponseTime;
        this.maxResponseTime = maxResponseTime;
        this.percentileResponseTime = percentileResponseTime;
        this.requestCount = requestCount;
        this.responseCount = responseCount;
        this.invalid = invalid;
        this.connectionErrors = connectionErrors;
        this.requestTimeouts = requestTimeouts;
        this.internalErrors = internalErrors;
        this.blockedTime = blockedTime;
        this.extensions = extensions;
    }

    public static void printHeader(PrintWriter writer, double[] percentiles) {
        writer.print("Requests,Responses,Mean,StdDev,Min,");
        for (double p : percentiles) {
            writer.print('p');
            writer.print(p);
            writer.print(',');
        }
        writer.print("Max,ConnectionErrors,RequestTimeouts,InternalErrors,Invalid,BlockedTime");
    }

    public void printTo(PrintWriter writer, String[] extensionHeaders) {
        writer.print(this.requestCount);
        writer.print(',');
        writer.print(this.responseCount);
        writer.print(',');
        writer.print(this.meanResponseTime);
        writer.print(',');
        writer.print(this.stdDevResponseTime);
        writer.print(',');
        writer.print(this.minResponseTime);
        writer.print(',');
        String[] stringArray = this.percentileResponseTime.values().iterator();
        while (stringArray.hasNext()) {
            long prt = stringArray.next();
            writer.print(prt);
            writer.print(',');
        }
        writer.print(this.maxResponseTime);
        writer.print(',');
        writer.print(this.connectionErrors);
        writer.print(',');
        writer.print(this.requestTimeouts);
        writer.print(',');
        writer.print(this.internalErrors);
        writer.print(',');
        writer.print(this.invalid);
        writer.print(',');
        writer.print(this.blockedTime);
        for (String header : extensionHeaders) {
            writer.print(',');
            int index = header.indexOf(46);
            StatsExtension value = (StatsExtension)this.extensions.get(header.substring(0, index));
            if (value == null) continue;
            writer.print(value.byHeader(header.substring(index + 1)));
        }
    }
}

