/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.statistics;

import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.api.statistics.StatsExtension;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.DoubleStream;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;

public class StatisticsSnapshot
implements Serializable {
    public int sequenceId = -1;
    public final Histogram histogram = new Histogram(TimeUnit.MINUTES.toNanos(1L), 2);
    public int requestCount;
    public int responseCount;
    public int invalid;
    public int connectionErrors;
    public int requestTimeouts;
    public int internalErrors;
    public long blockedTime;
    public final Map<String, StatsExtension> extensions = new HashMap<String, StatsExtension>();

    public boolean isEmpty() {
        return this.requestCount + this.responseCount + this.invalid + this.connectionErrors + this.requestTimeouts + this.internalErrors == 0 && this.extensions.values().stream().allMatch(StatsExtension::isNull);
    }

    public void reset() {
        this.histogram.reset();
        this.requestCount = 0;
        this.responseCount = 0;
        this.invalid = 0;
        this.connectionErrors = 0;
        this.requestTimeouts = 0;
        this.internalErrors = 0;
        this.blockedTime = 0L;
        for (StatsExtension value : this.extensions.values()) {
            if (value == null) continue;
            value.reset();
        }
    }

    public StatisticsSnapshot clone() {
        StatisticsSnapshot copy = new StatisticsSnapshot();
        copy.sequenceId = this.sequenceId;
        copy.add(this);
        return copy;
    }

    public void add(StatisticsSnapshot other) {
        this.histogram.add((AbstractHistogram)other.histogram);
        this.requestCount += other.requestCount;
        this.responseCount += other.responseCount;
        this.invalid += other.invalid;
        this.connectionErrors += other.connectionErrors;
        this.requestTimeouts += other.requestTimeouts;
        this.internalErrors += other.internalErrors;
        this.blockedTime += other.blockedTime;
        for (String key : other.extensions.keySet()) {
            StatsExtension their = other.extensions.get(key);
            StatsExtension my = this.extensions.get(key);
            if (their == null) continue;
            if (my == null) {
                this.extensions.put(key, their.clone());
                continue;
            }
            my.add(their);
        }
    }

    public void subtract(StatisticsSnapshot other) {
        this.histogram.subtract((AbstractHistogram)other.histogram);
        this.requestCount -= other.requestCount;
        this.responseCount -= other.responseCount;
        this.invalid -= other.invalid;
        this.connectionErrors -= other.connectionErrors;
        this.requestTimeouts -= other.requestTimeouts;
        this.internalErrors -= other.internalErrors;
        this.blockedTime -= other.blockedTime;
        for (String key : other.extensions.keySet()) {
            StatsExtension their = other.extensions.get(key);
            StatsExtension my = this.extensions.get(key);
            if (their == null) continue;
            if (my == null) {
                my = their.clone();
                my.reset();
                my.subtract(their);
                this.extensions.put(key, my);
                continue;
            }
            my.subtract(their);
        }
    }

    public StatisticsSummary summary(double[] percentiles) {
        TreeMap<Double, Long> percentilesMap = this.getPercentiles(percentiles);
        return new StatisticsSummary(this.histogram.getStartTimeStamp(), this.histogram.getEndTimeStamp(), this.histogram.getMinValue(), (long)this.histogram.getMean(), (long)this.histogram.getStdDeviation(), this.histogram.getMaxValue(), percentilesMap, this.requestCount, this.responseCount, this.invalid, this.connectionErrors, this.requestTimeouts, this.internalErrors, this.blockedTime, new TreeMap<String, StatsExtension>(this.extensions));
    }

    public TreeMap<Double, Long> getPercentiles(double[] percentiles) {
        return DoubleStream.of(percentiles).collect(TreeMap::new, (map, p) -> map.put(p, this.histogram.getValueAtPercentile(p)), TreeMap::putAll);
    }

    public long errors() {
        return this.connectionErrors + this.requestTimeouts + this.internalErrors;
    }

    public String toString() {
        return "StatisticsSnapshot{sequenceId=" + this.sequenceId + ", start=" + this.histogram.getStartTimeStamp() + ", end=" + this.histogram.getEndTimeStamp() + ", requestCount=" + this.requestCount + ", responseCount=" + this.responseCount + ", invalid=" + this.invalid + ", connectionErrors=" + this.connectionErrors + ", requestTimeouts=" + this.requestTimeouts + ", internalErrors=" + this.internalErrors + ", blockedTime=" + this.blockedTime + ", extensions=" + String.valueOf(this.extensions) + "}";
    }
}

