/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.statistics;

import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.api.statistics.StatsExtension;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.HdrHistogram.WriterReaderPhaser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Statistics {
    private static final Logger log = LogManager.getLogger(Statistics.class);
    private static final long SAMPLING_PERIOD_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final ThreadLocal<Long> lastWarnThrottle = ThreadLocal.withInitial(() -> Long.MIN_VALUE);
    private static final AtomicIntegerFieldUpdater<Statistics> LU1 = AtomicIntegerFieldUpdater.newUpdater(Statistics.class, "lowestActive1");
    private static final AtomicIntegerFieldUpdater<Statistics> LU2 = AtomicIntegerFieldUpdater.newUpdater(Statistics.class, "lowestActive2");
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private final long highestTrackableValue;
    private int numSamples = 4;
    private volatile int lowestActive1;
    private volatile int lowestActive2;
    private volatile int highestActive;
    private volatile AtomicIntegerFieldUpdater<Statistics> lowestActiveUpdater = LU1;
    private volatile AtomicReferenceArray<StatisticsSnapshot> active;
    private AtomicReferenceArray<StatisticsSnapshot> inactive;
    private long startTimestamp;
    private long endTimestamp = Long.MAX_VALUE;
    private int lastLowestIndex;

    public Statistics(long startTimestamp) {
        this.startTimestamp = startTimestamp;
        this.active = new AtomicReferenceArray(16);
        this.inactive = new AtomicReferenceArray(16);
        StatisticsSnapshot first = new StatisticsSnapshot();
        first.sequenceId = 0;
        this.active.set(0, first);
        this.highestTrackableValue = first.histogram.getHighestTrackableValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordResponse(long startTimestamp, long responseTime) {
        if (responseTime > this.highestTrackableValue) {
            long lastWarn = lastWarnThrottle.get();
            long warnings = lastWarn & 0xFFFFL;
            long now = System.currentTimeMillis();
            if (now - (lastWarn >> 16) > 100L) {
                log.warn("Response time {} exceeded maximum trackable response time {}", (Object)responseTime, (Object)this.highestTrackableValue);
                if (warnings > 0L) {
                    log.warn("Response time was also exceeded {} times since last warning", (Object)warnings);
                }
                lastWarnThrottle.set(now << 16);
            } else if (warnings < 65535L) {
                lastWarnThrottle.set(lastWarn + 1L);
            }
            responseTime = this.highestTrackableValue;
        } else if (responseTime < 0L) {
            log.warn("Response time {} is negative.", (Object)responseTime);
            responseTime = 0L;
        }
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(startTimestamp);
            active.histogram.recordValue(responseTime);
            ++active.responseCount;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRequests(long timestamp) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            ++active.requestCount;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementTimeouts(long timestamp) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            ++active.requestTimeouts;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementConnectionErrors(long timestamp) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            ++active.connectionErrors;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementInternalErrors(long timestamp) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            ++active.internalErrors;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementBlockedTime(long timestamp, long blockedTime) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            active.blockedTime += blockedTime;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends StatsExtension> void update(String key, long timestamp, Supplier<C> creator, LongUpdater<C> updater, long value) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            StatsExtension custom = active.extensions.get(key);
            if (custom == null) {
                custom = (StatsExtension)creator.get();
                active.extensions.put(key, custom);
            }
            updater.update(custom, value);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends StatsExtension> void update(String key, long timestamp, Supplier<C> creator, ObjectUpdater<C> updater, Object value) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            StatsExtension custom = active.extensions.get(key);
            if (custom == null) {
                custom = (StatsExtension)creator.get();
                active.extensions.put(key, custom);
            }
            updater.update(custom, value);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvalid(long timestamp) {
        long criticalValueAtEnter = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            StatisticsSnapshot active = this.active(timestamp);
            ++active.invalid;
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSnapshots(Consumer<StatisticsSnapshot> consumer) {
        try {
            this.recordingPhaser.readerLock();
            if (++this.numSamples >= this.inactive.length()) {
                AtomicReferenceArray<StatisticsSnapshot> temp = new AtomicReferenceArray<StatisticsSnapshot>(this.inactive.length() * 2);
                for (int i = this.lastLowestIndex; i < this.inactive.length(); ++i) {
                    temp.set(i, this.inactive.get(i));
                }
                this.inactive = temp;
            }
            AtomicReferenceArray<StatisticsSnapshot> tempHistogram = this.inactive;
            this.inactive = this.active;
            this.active = tempHistogram;
            AtomicIntegerFieldUpdater<Statistics> inactiveUpdater = this.lowestActiveUpdater;
            this.lowestActiveUpdater = inactiveUpdater == LU1 ? LU2 : LU1;
            this.recordingPhaser.flipPhase(500000L);
            this.lastLowestIndex = Math.min(LU1.get(this), LU2.get(this));
            int maxSamples = this.endTimestamp != Long.MAX_VALUE ? Math.min(this.inactive.length(), this.highestActive + 1) : Math.min(this.inactive.length() - 1, this.highestActive);
            inactiveUpdater.set(this, maxSamples);
            this.publish(this.inactive, maxSamples, consumer);
            if (this.endTimestamp != Long.MAX_VALUE) {
                this.publish(this.active, maxSamples, consumer);
            }
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    private void publish(AtomicReferenceArray<StatisticsSnapshot> array, int limit, Consumer<StatisticsSnapshot> consumer) {
        for (int i = this.lastLowestIndex; i < limit; ++i) {
            StatisticsSnapshot snapshot = array.get(i);
            if (snapshot == null) continue;
            if (snapshot.isEmpty()) {
                array.set(i, null);
                continue;
            }
            snapshot.histogram.setStartTimeStamp(this.startTimestamp + (long)i * SAMPLING_PERIOD_MILLIS);
            snapshot.histogram.setEndTimeStamp(Math.min(this.endTimestamp, this.startTimestamp + (long)(i + 1) * SAMPLING_PERIOD_MILLIS));
            consumer.accept(snapshot);
            snapshot.reset();
        }
    }

    public void start(long now) {
        this.recordingPhaser.readerLock();
        try {
            this.startTimestamp = now;
            this.endTimestamp = Long.MAX_VALUE;
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    public void end(long now) {
        this.recordingPhaser.readerLock();
        try {
            this.endTimestamp = now;
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    private StatisticsSnapshot active(long timestamp) {
        int index = (int)((timestamp - this.startTimestamp) / SAMPLING_PERIOD_MILLIS);
        AtomicReferenceArray<StatisticsSnapshot> active = this.active;
        if (index >= active.length()) {
            index = active.length() - 1;
        } else if (index < 0) {
            log.error("Record start timestamp {} predates statistics start {}", (Object)timestamp, (Object)this.startTimestamp);
            index = 0;
        }
        StatisticsSnapshot snapshot = active.get(index);
        if (snapshot == null) {
            snapshot = new StatisticsSnapshot();
            snapshot.sequenceId = index;
            active.set(index, snapshot);
        }
        this.lowestActiveUpdater.accumulateAndGet(this, index, Math::min);
        if (index > this.highestActive) {
            this.highestActive = index;
        }
        return snapshot;
    }

    public static interface LongUpdater<C extends StatsExtension> {
        public void update(C var1, long var2);
    }

    public static interface ObjectUpdater<C extends StatsExtension> {
        public void update(C var1, Object var2);
    }
}

