/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.session;

import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SessionStopException;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class SequenceInstance {
    private static final Logger log = LogManager.getLogger(SequenceInstance.class);
    private static final boolean trace = log.isTraceEnabled();
    private Sequence sequence;
    private Consumer<SequenceInstance> releaseHandler;
    private int index;
    private Step[] steps;
    private int currentStep = 0;
    private int refCnt = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean progress(Session session) {
        boolean progressed = false;
        while (this.currentStep < this.steps.length) {
            Step step = this.steps[this.currentStep];
            if (trace) {
                log.trace("#{} {}[{}] invoking step {}", (Object)session.uniqueId(), (Object)this.sequence.name(), (Object)this.index, (Object)StepBuilder.nameOf(step));
            }
            session.currentSequence(this);
            try {
                if (!step.invoke(session)) {
                    if (trace) {
                        log.trace("#{} {}[{}] step {} is blocked", (Object)session.uniqueId(), (Object)this.sequence.name(), (Object)this.index, (Object)StepBuilder.nameOf(step));
                    }
                    if (this.currentStep >= this.steps.length) {
                        log.warn("#{} Last step reported being blocked but it has also interrupted the sequence.", (Object)session.uniqueId());
                    }
                    boolean bl = progressed;
                    return bl;
                }
                if (!session.isActive()) {
                    throw SessionStopException.INSTANCE;
                }
            }
            catch (SessionStopException e) {
                throw e;
            }
            catch (Throwable t) {
                log.error((Message)new FormattedMessage("#{} phase {}, seq {}[{}] failure invoking step {}", new Object[]{session.uniqueId(), session.phase().definition().name(), this.sequence.name(), this.index, StepBuilder.nameOf(step)}), t);
                session.fail(t);
                boolean bl = false;
                return bl;
            }
            finally {
                session.currentSequence(null);
            }
            if (this.currentStep < this.steps.length) {
                ++this.currentStep;
            }
            progressed = true;
        }
        return progressed;
    }

    public SequenceInstance reset(Sequence sequence, int index, Step[] steps, Consumer<SequenceInstance> releaseHandler) {
        this.sequence = sequence;
        this.releaseHandler = releaseHandler;
        this.index = index;
        this.steps = steps;
        this.currentStep = 0;
        this.refCnt = 1;
        return this;
    }

    public boolean isCompleted() {
        return this.currentStep >= this.steps.length;
    }

    public boolean isLastStep() {
        return this.currentStep == this.steps.length - 1;
    }

    public int index() {
        return this.index;
    }

    public Sequence definition() {
        return this.sequence;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder sb) {
        return sb.append(this.sequence != null ? this.sequence.name() : "<none>").append('(').append(this.index).append(")(").append(this.currentStep + 1).append('/').append(this.steps == null ? 0 : this.steps.length).append(')');
    }

    public void breakSequence(Session session) {
        this.currentStep = this.steps.length;
        if (trace) {
            log.trace("#{} was interrupted", (Object)session.uniqueId());
        }
    }

    public void restart(Session session) {
        log.trace("#{} Restarting current sequence.", (Object)session.uniqueId());
        this.currentStep = -1;
    }

    public SequenceInstance incRefCnt() {
        ++this.refCnt;
        return this;
    }

    public void decRefCnt(Session session) {
        assert (this.refCnt > 0);
        if (--this.refCnt == 0) {
            if (trace) {
                log.trace("#{} Releasing sequence {}[{}]", (Object)session.uniqueId(), (Object)(this.sequence == null ? "<noseq>" : this.sequence.name()), (Object)this.index);
            }
            if (this.releaseHandler != null) {
                this.releaseHandler.accept(this);
            }
        } else if (trace) {
            log.trace("#{} Not releasing sequence {}[{}] - refCnt {}", (Object)(session == null ? 0 : session.uniqueId()), (Object)(this.sequence == null ? "<noseq>" : this.sequence.name()), (Object)this.index, (Object)this.refCnt);
        }
    }
}

