/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.IncludeBuilders;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.Session;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@IncludeBuilders(value={@IncludeBuilders.Conversion(from=Action.Builder.class, adapter=ActionBuilderConverter.class)})
public interface StepBuilder<S extends StepBuilder<S>>
extends BuilderBase<S> {
    public static String nameOf(StepBuilder<?> builder) {
        Name nameAnnotation;
        Class<?> builderClass = builder.getClass();
        if (builder instanceof ActionAdapter) {
            builderClass = ((ActionAdapter)builder).builder.getClass();
        }
        if ((nameAnnotation = builderClass.getAnnotation(Name.class)) != null) {
            return nameAnnotation.value();
        }
        if ("Builder".equals(builderClass.getSimpleName()) && builderClass.getEnclosingClass() != null) {
            return StepBuilder.simpleName(builderClass.getEnclosingClass());
        }
        return StepBuilder.simpleName(builderClass);
    }

    public static String nameOf(Step step) {
        if (step == null) {
            return null;
        }
        Serializable instance = step;
        if (step instanceof ActionStep) {
            instance = ((ActionStep)step).action;
        }
        Class<?> instanceClass = instance.getClass();
        for (Class<?> maybeBuilder : instanceClass.getClasses()) {
            if (!"Builder".equals(maybeBuilder.getSimpleName()) || !maybeBuilder.isAnnotationPresent(Name.class)) continue;
            return maybeBuilder.getAnnotation(Name.class).value();
        }
        return StepBuilder.simpleName(instanceClass);
    }

    private static String simpleName(Class<?> builderClass) {
        Object name = builderClass.getSimpleName();
        if (((String)(name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1))).endsWith("Step")) {
            return ((String)name).substring(0, ((String)name).length() - 4);
        }
        if (((String)name).endsWith("Action")) {
            return ((String)name).substring(0, ((String)name).length() - 6);
        }
        return name;
    }

    public List<Step> build();

    default public int id() {
        return -1;
    }

    public static class ActionAdapter
    implements StepBuilder<ActionAdapter> {
        final Action.Builder builder;

        public ActionAdapter(Action.Builder builder) {
            this.builder = builder;
        }

        @Override
        public void prepareBuild() {
            this.builder.prepareBuild();
        }

        @Override
        public ActionAdapter copy(Object newParent) {
            return new ActionAdapter((Action.Builder)this.builder.copy(null));
        }

        @Override
        public List<Step> build() {
            return Collections.singletonList(new ActionStep(this.builder.build()));
        }
    }

    public static class ActionStep
    implements Step {
        private final Action action;

        public ActionStep(Action action) {
            this.action = action;
        }

        @Override
        public boolean invoke(Session session) {
            this.action.run(session);
            return true;
        }
    }

    public static class ActionBuilderConverter
    implements Function<Action.Builder, StepBuilder> {
        @Override
        public StepBuilder apply(Action.Builder builder) {
            return new ActionAdapter(builder);
        }
    }
}

