/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.session.AccessVisitor;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.WriteAccess;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Scenario
implements Serializable {
    private final Sequence[] initialSequences;
    private final Sequence[] sequences;
    private final Map<String, Sequence> sequenceMap;
    private final int maxRequests;
    private final int maxSequences;
    private final int sumConcurrency;
    private final WriteAccess[] writes;
    private final int uniqueVars;

    public Scenario(Sequence[] initialSequences, Sequence[] sequences, int maxRequests, int maxSequences) {
        this.initialSequences = initialSequences;
        this.sequences = sequences;
        this.maxRequests = maxRequests;
        this.maxSequences = maxSequences;
        this.sequenceMap = Stream.of(sequences).collect(Collectors.toMap(Sequence::name, Function.identity()));
        this.sumConcurrency = this.sequenceMap.values().stream().mapToInt(Sequence::concurrency).sum();
        AccessVisitor visitor = new AccessVisitor();
        visitor.visit(sequences);
        this.writes = visitor.writes();
        ReadAccess[] reads = visitor.reads();
        Set writtenKeys = Arrays.stream(this.writes).map(ReadAccess::key).collect(Collectors.toSet());
        Set<Object> readKeys = Arrays.stream(reads).map(ReadAccess::key).filter(Objects::nonNull).collect(Collectors.toSet());
        readKeys.forEach(key -> {
            if (!writtenKeys.contains(key)) {
                throw new BenchmarkDefinitionException("Variable '" + String.valueOf(key) + "' is read but it is never written to.");
            }
        });
        HashMap keyIndexMap = new HashMap();
        for (Object t : readKeys) {
            keyIndexMap.put(t, keyIndexMap.size());
        }
        this.uniqueVars = keyIndexMap.size();
        for (ReadAccess access : reads) {
            if (access.key() == null) continue;
            access.setIndex((Integer)keyIndexMap.get(access.key()));
        }
    }

    public Sequence[] initialSequences() {
        return this.initialSequences;
    }

    public Sequence[] sequences() {
        return this.sequences;
    }

    public int maxRequests() {
        return this.maxRequests;
    }

    public int maxSequences() {
        return this.maxSequences;
    }

    public int sumConcurrency() {
        return this.sumConcurrency;
    }

    public Sequence sequence(String name) {
        Sequence sequence = this.sequenceMap.get(name);
        if (sequence == null) {
            throw new IllegalArgumentException("Unknown sequence '" + name + "'");
        }
        return sequence;
    }

    public Session.Var[] createVars(Session session) {
        Session.Var[] vars = new Session.Var[this.uniqueVars];
        for (WriteAccess access : this.writes) {
            int index = access.index();
            vars[index] = access.createVar(session, vars[index]);
        }
        return vars;
    }
}

