/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Model;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.PhaseForkBuilder;
import io.hyperfoil.api.config.PhaseReference;
import io.hyperfoil.api.config.PhaseReferenceDelay;
import io.hyperfoil.api.config.RelativeIteration;
import io.hyperfoil.api.config.SLA;
import io.hyperfoil.api.config.SLABuilder;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.config.SessionLimitPolicy;
import io.hyperfoil.api.config.StartWithDelay;
import io.hyperfoil.function.SerializableSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class PhaseBuilder<PB extends PhaseBuilder<PB>> {
    protected final String name;
    protected final BenchmarkBuilder parent;
    protected long startTime = -1L;
    protected Collection<PhaseReference> startAfter = new ArrayList<PhaseReference>();
    protected Collection<PhaseReference> startAfterStrict = new ArrayList<PhaseReference>();
    protected Collection<PhaseReference> terminateAfterStrict = new ArrayList<PhaseReference>();
    protected long duration = -1L;
    protected long maxDuration = -1L;
    protected int maxIterations = 1;
    protected boolean forceIterations = false;
    protected List<PhaseForkBuilder> forks = new ArrayList<PhaseForkBuilder>();
    protected boolean isWarmup = false;
    protected Map<String, List<SLABuilder<PB>>> customSlas = new HashMap<String, List<SLABuilder<PB>>>();
    protected PhaseReferenceDelay startWith;

    protected PhaseBuilder(BenchmarkBuilder parent, String name) {
        this.name = name;
        this.parent = parent;
        parent.addPhase(name, this);
    }

    public static Phase noop(SerializableSupplier<Benchmark> benchmark, int id, int iteration, String iterationName, long duration, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict) {
        Scenario scenario = new Scenario(new Sequence[0], new Sequence[0], 0, 0);
        return new Phase(benchmark, id, iteration, iterationName, scenario, -1L, startAfter, startAfterStrict, terminateAfterStrict, duration, duration, null, true, new Model.Noop(), Collections.emptyMap(), null);
    }

    public BenchmarkBuilder endPhase() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public ScenarioBuilder scenario() {
        if (this.forks.isEmpty()) {
            PhaseForkBuilder fork = new PhaseForkBuilder(this, null);
            this.forks.add(fork);
            return fork.scenario;
        }
        if (this.forks.size() == 1 && this.forks.get((int)0).name == null) {
            throw new BenchmarkDefinitionException("Scenario for " + this.name + " already set!");
        }
        throw new BenchmarkDefinitionException("Scenario is forked; you need to specify another fork.");
    }

    protected PB self() {
        return (PB)this;
    }

    public PhaseForkBuilder fork(String name) {
        if (this.forks.size() == 1 && this.forks.get((int)0).name == null) {
            throw new BenchmarkDefinitionException("Scenario for " + name + " already set!");
        }
        PhaseForkBuilder fork = new PhaseForkBuilder(this, name);
        this.forks.add(fork);
        return fork;
    }

    public PB startTime(long startTime) {
        this.startTime = startTime;
        return this.self();
    }

    public PB startAfter(String phase) {
        this.startAfter.add(new PhaseReference(phase, RelativeIteration.NONE, null));
        return this.self();
    }

    public PB startAfter(PhaseReference phase) {
        this.startAfter.add(phase);
        return this.self();
    }

    public PB startAfterStrict(String phase) {
        this.startAfterStrict.add(new PhaseReference(phase, RelativeIteration.NONE, null));
        return this.self();
    }

    public PB startAfterStrict(PhaseReference phase) {
        this.startAfterStrict.add(phase);
        return this.self();
    }

    public PB startWith(String phase) {
        if (this.startWith != null) {
            throw new BenchmarkDefinitionException("Start with " + this.startWith.phase + " already defined, cannot set multiple startWith clauses");
        }
        this.startWith = new PhaseReferenceDelay(phase, RelativeIteration.NONE, null, 0L);
        return this.self();
    }

    public PB startWith(PhaseReferenceDelay startWith) {
        if (this.startWith != null) {
            throw new BenchmarkDefinitionException("Start with " + this.startWith.phase + " already defined, cannot set multiple startWith clauses");
        }
        this.startWith = startWith;
        return this.self();
    }

    public PB duration(long duration) {
        this.duration = duration;
        return this.self();
    }

    public PB maxDuration(long maxDuration) {
        this.maxDuration = maxDuration;
        return this.self();
    }

    public PB maxIterations(int iterations) {
        this.maxIterations = iterations;
        return this.self();
    }

    public void prepareBuild() {
        this.forks.forEach(fork -> fork.scenario.prepareBuild());
    }

    public Collection<Phase> build(SerializableSupplier<Benchmark> benchmark, AtomicInteger idCounter) {
        if (this.forks.isEmpty()) {
            throw new BenchmarkDefinitionException("Scenario for " + this.name + " is not defined.");
        }
        if (this.forks.size() == 1 && this.forks.get((int)0).name != null) {
            throw new BenchmarkDefinitionException(this.name + " has single fork: define scenario directly.");
        }
        boolean hasForks = this.forks.size() > 1;
        this.forks.removeIf(fork -> fork.weight <= 0.0);
        if (this.forks.isEmpty()) {
            throw new BenchmarkDefinitionException("Phase " + this.name + " does not have any forks with positive weight.");
        }
        double sumWeight = this.forks.stream().mapToDouble(f -> f.weight).sum();
        this.forks.forEach(f -> f.weight /= sumWeight);
        List<Phase> phases = IntStream.range(0, this.maxIterations).mapToObj(iteration -> this.forks.stream().map(f -> this.buildPhase(benchmark, idCounter.getAndIncrement(), iteration, (PhaseForkBuilder)f))).flatMap(Function.identity()).collect(Collectors.toList());
        if (this.maxIterations > 1 || this.forceIterations) {
            if (hasForks) {
                IntStream.range(0, this.maxIterations).mapToObj(iteration -> {
                    String iterationName = this.formatIteration(this.name, iteration);
                    List<String> forks = this.forks.stream().map(f -> iterationName + "/" + f.name).collect(Collectors.toList());
                    return PhaseBuilder.noop(benchmark, idCounter.getAndIncrement(), iteration, iterationName, 0L, forks, Collections.emptyList(), forks);
                }).forEach(phases::add);
            }
            List<String> lastIteration = Collections.singletonList(this.formatIteration(this.name, this.maxIterations - 1));
            phases.add(PhaseBuilder.noop(benchmark, idCounter.getAndIncrement(), 0, this.name, 0L, lastIteration, Collections.emptyList(), lastIteration));
        } else if (hasForks) {
            List<String> forks = this.forks.stream().map(f -> this.name + "/" + f.name).collect(Collectors.toList());
            phases.add(PhaseBuilder.noop(benchmark, idCounter.getAndIncrement(), 0, this.name, 0L, forks, Collections.emptyList(), forks));
        }
        return phases;
    }

    protected Phase buildPhase(SerializableSupplier<Benchmark> benchmark, int phaseId, int iteration, PhaseForkBuilder f) {
        Collector<Map.Entry, ?, Map<String, SLA[]>> customSlaCollector = Collectors.toMap(Map.Entry::getKey, entry -> (SLA[])((List)entry.getValue()).stream().map(SLABuilder::build).toArray(SLA[]::new));
        return new Phase(benchmark, phaseId, iteration, this.iterationName(iteration, f.name), f.scenario.build(), this.iterationStartTime(iteration), this.iterationReferences(this.startAfter, iteration, false), this.iterationReferences(this.startAfterStrict, iteration, true), this.iterationReferences(this.terminateAfterStrict, iteration, false), this.duration, this.maxDuration, this.sharedResources(f), this.isWarmup, this.createModel(iteration, f.weight), Collections.unmodifiableMap(this.customSlas.entrySet().stream().collect(customSlaCollector)), this.iterationStartWith(this.startWith, iteration));
    }

    String iterationName(int iteration, String forkName) {
        if (this.maxIterations == 1 && !this.forceIterations) {
            assert (iteration == 0);
            if (forkName == null) {
                return this.name;
            }
            return this.name + "/" + forkName;
        }
        String iterationName = this.formatIteration(this.name, iteration);
        if (forkName == null) {
            return iterationName;
        }
        return iterationName + "/" + forkName;
    }

    String formatIteration(String name, int iteration) {
        return String.format("%s/%03d", name, iteration);
    }

    long iterationStartTime(int iteration) {
        return iteration == 0 ? this.startTime : -1L;
    }

    String sharedResources(PhaseForkBuilder fork) {
        if (fork == null || fork.name == null) {
            return this.name;
        }
        return this.name + "/" + fork.name;
    }

    Collection<String> iterationReferences(Collection<PhaseReference> refs, int iteration, boolean addSelfPrevious) {
        ArrayList<String> names = new ArrayList<String>();
        block5: for (PhaseReference ref : refs) {
            if (ref.iteration != RelativeIteration.NONE && this.maxIterations <= 1 && !this.forceIterations) {
                String msg = "Phase " + this.name + " tries to reference " + ref.phase + "/" + String.valueOf((Object)ref.iteration) + (String)(ref.fork == null ? "" : "/" + ref.fork) + " but this phase does not have any iterations (cannot determine relative iteration).";
                throw new BenchmarkDefinitionException(msg);
            }
            switch (ref.iteration) {
                case NONE: {
                    names.add(ref.phase);
                    continue block5;
                }
                case PREVIOUS: {
                    if (iteration <= 0) continue block5;
                    names.add(this.formatIteration(ref.phase, iteration - 1));
                    continue block5;
                }
                case SAME: {
                    names.add(this.formatIteration(ref.phase, iteration));
                    continue block5;
                }
            }
            throw new IllegalArgumentException();
        }
        if (addSelfPrevious && iteration > 0) {
            names.add(this.formatIteration(this.name, iteration - 1));
        }
        return names;
    }

    StartWithDelay iterationStartWith(PhaseReferenceDelay startWith, int iteration) {
        if (startWith == null) {
            return null;
        }
        if (startWith.iteration != RelativeIteration.NONE && this.maxIterations <= 1 && !this.forceIterations) {
            String msg = "Phase " + this.name + " tries to reference " + startWith.phase + "/" + String.valueOf((Object)startWith.iteration) + " but this phase does not have any iterations (cannot determine relative iteration).";
            throw new BenchmarkDefinitionException(msg);
        }
        String phase = null;
        switch (startWith.iteration) {
            case NONE: {
                phase = startWith.phase;
                break;
            }
            case PREVIOUS: {
                if (iteration <= 0) break;
                phase = this.formatIteration(startWith.phase, iteration - 1);
                break;
            }
            case SAME: {
                phase = this.formatIteration(startWith.phase, iteration - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return phase != null ? new StartWithDelay(phase, startWith.delay) : null;
    }

    public void readForksFrom(PhaseBuilder<?> other) {
        for (PhaseForkBuilder builder : other.forks) {
            this.fork(builder.name).readFrom(builder);
        }
    }

    public void readCustomSlaFrom(PhaseBuilder<?> other) {
        for (Map.Entry<String, List<SLABuilder<PB>>> entry : other.customSlas.entrySet()) {
            this.customSlas.put(entry.getKey(), entry.getValue().stream().map(b -> {
                SLABuilder copy = (SLABuilder)b.copy(this);
                return copy;
            }).collect(Collectors.toList()));
        }
    }

    public PB forceIterations(boolean force) {
        this.forceIterations = force;
        return this.self();
    }

    public PB isWarmup(boolean isWarmup) {
        this.isWarmup = isWarmup;
        return this.self();
    }

    public SLABuilder<PB> customSla(String metric) {
        List list = this.customSlas.computeIfAbsent(metric, m -> new ArrayList());
        SLABuilder<PB> builder = new SLABuilder<PB>(this.self());
        list.add(builder);
        return builder;
    }

    protected abstract Model createModel(int var1, double var2);

    public static class Catalog {
        private final BenchmarkBuilder parent;
        private final String name;

        Catalog(BenchmarkBuilder parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public Noop noop() {
            return new Noop(this.parent, this.name);
        }

        public AtOnce atOnce(int users) {
            return new AtOnce(this.parent, this.name, users);
        }

        public Always always(int users) {
            return new Always(this.parent, this.name, users);
        }

        public RampRate rampRate(int initialUsersPerSec, int targetUsersPerSec) {
            return new RampRate(this.parent, this.name, initialUsersPerSec, targetUsersPerSec);
        }

        public ConstantRate constantRate(int usersPerSec) {
            return new ConstantRate(this.parent, this.name, usersPerSec);
        }

        public Sequentially sequentially(int repeats) {
            return new Sequentially(this.parent, this.name, repeats);
        }
    }

    public static class Sequentially
    extends PhaseBuilder<Sequentially> {
        private int repeats;

        protected Sequentially(BenchmarkBuilder parent, String name, int repeats) {
            super(parent, name);
            this.repeats = repeats;
        }

        @Override
        protected Model createModel(int iteration, double weight) {
            if (this.repeats <= 0) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ".repeats must be positive");
            }
            return new Model.Sequentially(this.repeats);
        }
    }

    public static class ConstantRate
    extends OpenModel<ConstantRate> {
        private double usersPerSec;
        private double usersPerSecIncrement;

        ConstantRate(BenchmarkBuilder parent, String name, double usersPerSec) {
            super(parent, name);
            this.usersPerSec = usersPerSec;
        }

        @Override
        protected Model createModel(int iteration, double weight) {
            int maxSessions = this.maxSessions <= 0 ? (int)Math.ceil(weight * (this.usersPerSec + this.usersPerSecIncrement * (double)(this.maxIterations - 1))) : (int)Math.round((double)this.maxSessions * weight);
            if (this.usersPerSec <= 0.0) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ".usersPerSec must be positive.");
            }
            double rate = (this.usersPerSec + this.usersPerSecIncrement * (double)iteration) * weight;
            return new Model.ConstantRate(rate, this.variance, maxSessions, this.sessionLimitPolicy);
        }

        public ConstantRate usersPerSec(double usersPerSec) {
            this.usersPerSec = usersPerSec;
            return this;
        }

        public ConstantRate usersPerSec(double base, double increment) {
            this.usersPerSec = base;
            this.usersPerSecIncrement = increment;
            return this;
        }
    }

    public static class RampRate
    extends OpenModel<RampRate> {
        private double initialUsersPerSec;
        private double initialUsersPerSecIncrement;
        private double targetUsersPerSec;
        private double targetUsersPerSecIncrement;
        private Predicate<Model.RampRate> constraint;
        private String constraintMessage;

        RampRate(BenchmarkBuilder parent, String name, double initialUsersPerSec, double targetUsersPerSec) {
            super(parent, name);
            this.initialUsersPerSec = initialUsersPerSec;
            this.targetUsersPerSec = targetUsersPerSec;
        }

        @Override
        protected Model createModel(int iteration, double weight) {
            int maxSessions;
            if (this.maxSessions > 0) {
                maxSessions = (int)Math.round((double)this.maxSessions * weight);
            } else {
                double maxInitialUsers = this.initialUsersPerSec + this.initialUsersPerSecIncrement * (double)(this.maxIterations - 1);
                double maxTargetUsers = this.targetUsersPerSec + this.targetUsersPerSecIncrement * (double)(this.maxIterations - 1);
                maxSessions = (int)Math.ceil(Math.max(maxInitialUsers, maxTargetUsers) * weight);
            }
            if (this.initialUsersPerSec < 0.0) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ".initialUsersPerSec must be non-negative");
            }
            if (this.targetUsersPerSec < 0.0) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ".targetUsersPerSec must be non-negative");
            }
            if (this.initialUsersPerSec < 1.0E-4 && this.targetUsersPerSec < 1.0E-4) {
                throw new BenchmarkDefinitionException("In phase " + this.name + " both initialUsersPerSec and targetUsersPerSec are 0");
            }
            double initial = (this.initialUsersPerSec + this.initialUsersPerSecIncrement * (double)iteration) * weight;
            double target = (this.targetUsersPerSec + this.targetUsersPerSecIncrement * (double)iteration) * weight;
            Model.RampRate model = new Model.RampRate(initial, target, this.variance, maxSessions, this.sessionLimitPolicy);
            if (this.constraint != null && !this.constraint.test(model)) {
                throw new BenchmarkDefinitionException("Phase " + this.name + " failed constraints: " + this.constraintMessage);
            }
            return model;
        }

        public RampRate initialUsersPerSec(double initialUsersPerSec) {
            this.initialUsersPerSec = initialUsersPerSec;
            this.initialUsersPerSecIncrement = 0.0;
            return this;
        }

        public RampRate initialUsersPerSec(double base, double increment) {
            this.initialUsersPerSec = base;
            this.initialUsersPerSecIncrement = increment;
            return this;
        }

        public RampRate targetUsersPerSec(double targetUsersPerSec) {
            this.targetUsersPerSec = targetUsersPerSec;
            this.targetUsersPerSecIncrement = 0.0;
            return this;
        }

        public RampRate targetUsersPerSec(double base, double increment) {
            this.targetUsersPerSec = base;
            this.targetUsersPerSecIncrement = increment;
            return this;
        }

        public RampRate constraint(Predicate<Model.RampRate> constraint, String constraintMessage) {
            this.constraint = constraint;
            this.constraintMessage = constraintMessage;
            return this;
        }
    }

    public static abstract class OpenModel<P extends PhaseBuilder<P>>
    extends PhaseBuilder<P> {
        protected int maxSessions;
        protected boolean variance = true;
        protected SessionLimitPolicy sessionLimitPolicy = SessionLimitPolicy.FAIL;

        protected OpenModel(BenchmarkBuilder parent, String name) {
            super(parent, name);
        }

        public P maxSessions(int maxSessions) {
            this.maxSessions = maxSessions;
            return (P)this;
        }

        public P variance(boolean variance) {
            this.variance = variance;
            return (P)this;
        }

        public P sessionLimitPolicy(SessionLimitPolicy sessionLimitPolicy) {
            this.sessionLimitPolicy = sessionLimitPolicy;
            return (P)this;
        }
    }

    public static class Always
    extends ClosedModel<Always> {
        Always(BenchmarkBuilder parent, String name, int users) {
            super(parent, name, users);
        }

        @Override
        protected Model createModel(int iteration, double weight) {
            this.validate();
            return new Model.Always((int)Math.round((double)(this.users + this.usersIncrement * iteration) * weight), (int)Math.round((double)this.usersPerAgent * weight), (int)Math.round((double)this.usersPerThread * weight));
        }
    }

    public static class AtOnce
    extends ClosedModel<AtOnce> {
        AtOnce(BenchmarkBuilder parent, String name, int users) {
            super(parent, name, users);
        }

        @Override
        protected Model createModel(int iteration, double weight) {
            this.validate();
            return new Model.AtOnce((int)Math.round((double)(this.users + this.usersIncrement * iteration) * weight), (int)Math.round((double)this.usersPerAgent * weight), (int)Math.round((double)this.usersPerThread * weight));
        }
    }

    public static abstract class ClosedModel<T extends ClosedModel<T>>
    extends PhaseBuilder<T> {
        protected int users;
        protected int usersIncrement;
        protected int usersPerAgent;
        protected int usersPerThread;

        protected ClosedModel(BenchmarkBuilder parent, String name, int users) {
            super(parent, name);
            this.users = users;
        }

        public T users(int users) {
            this.users = users;
            return (T)((ClosedModel)this.self());
        }

        public T users(int base, int increment) {
            this.users = base;
            this.usersIncrement = increment;
            return (T)((ClosedModel)this.self());
        }

        public T usersPerAgent(int usersPerAgent) {
            this.usersPerAgent = usersPerAgent;
            return (T)((ClosedModel)this.self());
        }

        public T usersPerThread(int usersPerThread) {
            this.usersPerThread = usersPerThread;
            return (T)((ClosedModel)this.self());
        }

        protected void validate() {
            long propsSet = IntStream.of(this.users, this.usersPerAgent, this.usersPerThread).filter(u -> u > 0).count();
            if (propsSet < 1L) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ".users (or .usersPerAgent/.usersPerThread) must be positive.");
            }
            if (propsSet > 1L) {
                throw new BenchmarkDefinitionException("Phase " + this.name + ": you can set only one of .users, .usersPerAgent and .usersPerThread");
            }
        }
    }

    public static class Noop
    extends PhaseBuilder<Noop> {
        protected Noop(BenchmarkBuilder parent, String name) {
            super(parent, name);
        }

        @Override
        public Collection<Phase> build(SerializableSupplier<Benchmark> benchmark, AtomicInteger idCounter) {
            List<Phase> phases = IntStream.range(0, this.maxIterations).mapToObj(iteration -> PhaseBuilder.noop(benchmark, idCounter.getAndIncrement(), iteration, this.iterationName(iteration, null), this.duration, this.iterationReferences(this.startAfter, iteration, false), this.iterationReferences(this.startAfterStrict, iteration, true), this.iterationReferences(this.terminateAfterStrict, iteration, false))).collect(Collectors.toList());
            if (this.maxIterations > 1 || this.forceIterations) {
                List<String> lastIteration = Collections.singletonList(this.formatIteration(this.name, this.maxIterations - 1));
                phases.add(Noop.noop(benchmark, idCounter.getAndIncrement(), 0, this.name, this.duration, lastIteration, Collections.emptyList(), lastIteration));
            }
            return phases;
        }

        @Override
        protected Model createModel(int iteration, double weight) {
            throw new UnsupportedOperationException();
        }
    }
}

