/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Model;
import io.hyperfoil.api.config.SLA;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.StartWithDelay;
import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Phase
implements Serializable {
    protected static final Logger log = LogManager.getLogger(Phase.class);
    protected static final boolean trace = log.isTraceEnabled();
    @Visitor.Ignore
    protected final SerializableSupplier<Benchmark> benchmark;
    @Visitor.Ignore
    public final int id;
    public final int iteration;
    @Visitor.Ignore
    public final String name;
    public final Scenario scenario;
    public final long startTime;
    public final Collection<String> startAfter;
    public final Collection<String> startAfterStrict;
    public final Collection<String> terminateAfterStrict;
    public final long duration;
    public final long maxDuration;
    public final String sharedResources;
    public final Model model;
    public final boolean isWarmup;
    public final Map<String, SLA[]> customSlas;
    public final StartWithDelay startWithDelay;

    public Phase(SerializableSupplier<Benchmark> benchmark, int id, int iteration, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, String sharedResources, boolean isWarmup, Model model, Map<String, SLA[]> customSlas, StartWithDelay startWithDelay) {
        this.benchmark = benchmark;
        this.id = id;
        this.iteration = iteration;
        this.name = name;
        this.terminateAfterStrict = terminateAfterStrict;
        this.maxDuration = maxDuration;
        this.startAfter = startAfter;
        this.startAfterStrict = startAfterStrict;
        this.scenario = scenario;
        this.startTime = startTime;
        this.duration = duration;
        this.sharedResources = sharedResources;
        this.isWarmup = isWarmup;
        this.model = model;
        this.customSlas = customSlas;
        this.startWithDelay = startWithDelay;
        if (scenario == null) {
            throw new BenchmarkDefinitionException("Scenario was not set for phase '" + name + "'");
        }
        model.validate(this);
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Scenario scenario() {
        return this.scenario;
    }

    public long startTime() {
        return this.startTime;
    }

    public Collection<String> startAfter() {
        return this.startAfter;
    }

    public Collection<String> startAfterStrict() {
        return this.startAfterStrict;
    }

    public Collection<String> terminateAfterStrict() {
        return this.terminateAfterStrict;
    }

    public long duration() {
        return this.duration;
    }

    public long maxDuration() {
        return this.maxDuration;
    }

    public Benchmark benchmark() {
        return (Benchmark)this.benchmark.get();
    }

    public String description() {
        return this.model.description();
    }

    public StartWithDelay startWithDelay() {
        return this.startWithDelay;
    }

    public Collection<String> getDependencies() {
        Stream<String> dependencies = Stream.concat(this.startAfter().stream(), this.startAfterStrict().stream());
        if (this.startWithDelay() != null) {
            dependencies = Stream.concat(dependencies, Stream.of(this.startWithDelay().phase));
        }
        return dependencies.collect(Collectors.toList());
    }
}

