/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.StepBuilder;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface BuilderBase<S extends BuilderBase<S>> {
    default public void prepareBuild() {
        for (Class<?> clz = this.getClass(); clz != null && clz != Object.class; clz = clz.getSuperclass()) {
            for (Field f : clz.getDeclaredFields()) {
                if (f.isSynthetic() || Modifier.isStatic(f.getModifiers()) || "parent".equals(f.getName())) continue;
                f.setAccessible(true);
                try {
                    this.tryPrepare(clz, f.getName(), f.getType(), f.get(this));
                }
                catch (IllegalAccessException e) {
                    throw new UnsupportedOperationException("Cannot get value of " + clz.getName() + "." + f.getName() + " (actual instance: " + String.valueOf(this) + ")");
                }
            }
        }
    }

    private void tryPrepare(Class<?> clz, String name, Class<?> type, Object value) throws IllegalAccessException {
        if (BuilderBase.class.isAssignableFrom(type)) {
            if (value != null) {
                ((BuilderBase)value).prepareBuild();
            }
        } else if (Collection.class.isAssignableFrom(type)) {
            if (value != null) {
                for (Object item : (Collection)value) {
                    if (item == null) continue;
                    this.tryPrepare(clz, name, item.getClass(), item);
                }
            }
        } else if (BaseSequenceBuilder.class.isAssignableFrom(type)) {
            if (value != null) {
                ((BaseSequenceBuilder)value).prepareBuild();
            }
        } else if (Map.class.isAssignableFrom(type)) {
            if (value != null) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    if (entry.getKey() != null) {
                        this.tryPrepare(clz, name, entry.getKey().getClass(), entry.getKey());
                    }
                    if (entry.getValue() == null) continue;
                    this.tryPrepare(clz, name, entry.getValue().getClass(), entry.getValue());
                }
            }
        } else if (type.isArray()) {
            throw new UnsupportedOperationException(clz.getName() + "." + name + " is an array (actual instance: " + String.valueOf(this) + ")");
        }
    }

    default public S copy(Object newParent) {
        if (this.getClass().isSynthetic()) {
            if (!1.$assertionsDisabled && !this.getClass().getSimpleName().contains("$$Lambda")) {
                throw new AssertionError();
            }
            return (S)this;
        }
        try {
            ThrowingSupplier<BuilderBase> constructor = null;
            for (Constructor<?> ctor : this.getClass().getConstructors()) {
                if (ctor.getParameterCount() == 0 && constructor == null) {
                    constructor = () -> (BuilderBase)ctor.newInstance(new Object[0]);
                    continue;
                }
                if (ctor.getParameterCount() != 1) continue;
                Class<?> parameterType = ctor.getParameterTypes()[0];
                if (parameterType == this.getClass()) {
                    constructor = () -> (BuilderBase)ctor.newInstance(this);
                    break;
                }
                if (newParent == null || !parameterType.isAssignableFrom(newParent.getClass())) continue;
                constructor = () -> (BuilderBase)ctor.newInstance(newParent);
            }
            if (constructor == null) {
                throw new NoSuchMethodException("No constructor for " + this.getClass().getName());
            }
            BuilderBase copy = (BuilderBase)constructor.get();
            for (Class<?> cls = this.getClass(); cls != null && cls != BuilderBase.class; cls = cls.getSuperclass()) {
                for (Field f : cls.getDeclaredFields()) {
                    f.setAccessible(true);
                    if (Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(IgnoreCopy.class)) continue;
                    if (Modifier.isFinal(f.getModifiers())) {
                        Object copyValue;
                        Object thisValue = f.get(this);
                        if (thisValue == (copyValue = f.get(copy))) continue;
                        if (copyValue instanceof Collection) {
                            Collection copyCollection = (Collection)copyValue;
                            copyCollection.clear();
                            copyCollection.addAll((Collection)CopyUtil.deepCopy(thisValue, copy));
                            continue;
                        }
                        if (f.getName().equals("parent")) continue;
                        if (copyValue instanceof BaseSequenceBuilder && thisValue instanceof BaseSequenceBuilder) {
                            List<StepBuilder<?>> newSteps = ((BaseSequenceBuilder)copyValue).steps;
                            ((BaseSequenceBuilder)thisValue).steps.forEach(sb -> newSteps.add((StepBuilder)sb.copy(copyValue)));
                            continue;
                        }
                        throw new UnsupportedOperationException(cls.getName() + "." + f.getName() + " is final (actual instance: " + String.valueOf(this) + ")");
                    }
                    if (f.getType().isPrimitive()) {
                        if (f.getType() == Boolean.TYPE) {
                            f.setBoolean(copy, f.getBoolean(this));
                            continue;
                        }
                        if (f.getType() == Integer.TYPE) {
                            f.setInt(copy, f.getInt(this));
                            continue;
                        }
                        if (f.getType() == Long.TYPE) {
                            f.setLong(copy, f.getLong(this));
                            continue;
                        }
                        if (f.getType() == Double.TYPE) {
                            f.setDouble(copy, f.getDouble(this));
                            continue;
                        }
                        if (f.getType() == Float.TYPE) {
                            f.setFloat(copy, f.getFloat(this));
                            continue;
                        }
                        if (f.getType() == Byte.TYPE) {
                            f.setByte(copy, f.getByte(this));
                            continue;
                        }
                        if (f.getType() == Character.TYPE) {
                            f.setChar(copy, f.getChar(this));
                            continue;
                        }
                        if (f.getType() == Short.TYPE) {
                            f.setShort(copy, f.getShort(this));
                            continue;
                        }
                        throw new UnsupportedOperationException("Unknown primitive: " + String.valueOf(f.getType()));
                    }
                    if (f.getType().isArray()) {
                        if (f.getType().getComponentType() == Byte.TYPE) {
                            byte[] bytes = (byte[])f.get(this);
                            f.set(copy, bytes == null ? null : Arrays.copyOf(bytes, bytes.length));
                            continue;
                        }
                        throw new UnsupportedOperationException(cls.getName() + "." + f.getName() + " is an array (actual instance: " + String.valueOf(this) + ")");
                    }
                    f.set(copy, CopyUtil.deepCopy(f.get(this), copy));
                }
            }
            return (S)copy;
        }
        catch (ReflectiveOperationException e) {
            throw new BenchmarkDefinitionException("Default deep copy failed", e);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface ThrowingSupplier<T> {
        public T get() throws ReflectiveOperationException;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IgnoreCopy {
    }

    public static class CopyUtil {
        private static Object deepCopy(Object o, Object newParent) throws ReflectiveOperationException {
            if (o == null) {
                return null;
            }
            if (BuilderBase.class.isAssignableFrom(o.getClass())) {
                return ((BuilderBase)o).copy(newParent);
            }
            if (Collection.class.isAssignableFrom(o.getClass())) {
                Collection thisCollection = (Collection)o;
                Collection newCollection = (Collection)thisCollection.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                for (Object item : thisCollection) {
                    newCollection.add(CopyUtil.deepCopy(item, newParent));
                }
                return newCollection;
            }
            if (Map.class.isAssignableFrom(o.getClass())) {
                Map thisMap = (Map)o;
                Map newMap = (Map)thisMap.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                for (Map.Entry entry : thisMap.entrySet()) {
                    newMap.put(CopyUtil.deepCopy(entry.getKey(), null), CopyUtil.deepCopy(entry.getValue(), newParent));
                }
                return newMap;
            }
            return o;
        }
    }
}

