/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Agent;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.PluginBuilder;
import io.hyperfoil.api.config.PluginConfig;
import io.hyperfoil.api.config.RunHook;
import io.hyperfoil.impl.FutureSupplier;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BenchmarkBuilder {
    private final BenchmarkSource source;
    private final Map<String, String> params;
    private BenchmarkData data;
    private String name;
    private Map<String, String> defaultAgentProperties = Collections.emptyMap();
    private final Collection<Agent> agents = new ArrayList<Agent>();
    private final Map<Class<? extends PluginBuilder<?>>, PluginBuilder<?>> plugins = new HashMap();
    private int threads = 1;
    private final Map<String, PhaseBuilder<?>> phaseBuilders = new HashMap();
    private long statisticsCollectionPeriod = 1000L;
    private String triggerUrl;
    private final List<RunHook> preHooks = new ArrayList<RunHook>();
    private final List<RunHook> postHooks = new ArrayList<RunHook>();
    private Benchmark.FailurePolicy failurePolicy = Benchmark.FailurePolicy.CANCEL;

    public static Collection<PhaseBuilder<?>> phasesForTesting(BenchmarkBuilder builder) {
        return builder.phaseBuilders.values();
    }

    public BenchmarkBuilder(BenchmarkSource source, Map<String, String> params) {
        this.source = source;
        this.params = params;
        this.data = source == null ? BenchmarkData.EMPTY : source.data;
    }

    public static BenchmarkBuilder builder() {
        return new BenchmarkBuilder(null, Collections.emptyMap());
    }

    public BenchmarkSource source() {
        return this.source;
    }

    public BenchmarkBuilder name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public BenchmarkBuilder addAgent(String name, String inlineConfig, Map<String, String> properties) {
        Agent agent = new Agent(name, inlineConfig, properties);
        if (this.agents.stream().anyMatch(a -> a.name.equals(agent.name))) {
            throw new BenchmarkDefinitionException("Benchmark already contains agent '" + agent.name + "'");
        }
        this.agents.add(agent);
        return this;
    }

    int numAgents() {
        return this.agents.size();
    }

    public BenchmarkBuilder threads(int threads) {
        this.threads = threads;
        return this;
    }

    public PhaseBuilder.Catalog addPhase(String name) {
        return new PhaseBuilder.Catalog(this, name);
    }

    public PhaseBuilder.ConstantRate singleConstantRatePhase() {
        if (this.phaseBuilders.isEmpty()) {
            return new PhaseBuilder.Catalog(this, "main").constantRate(0);
        }
        PhaseBuilder<?> builder = this.phaseBuilders.get("main");
        if (!(builder instanceof PhaseBuilder.ConstantRate)) {
            throw new BenchmarkDefinitionException("Benchmark already has defined phases; cannot use single-phase definition");
        }
        return (PhaseBuilder.ConstantRate)builder;
    }

    public BenchmarkBuilder triggerUrl(String url) {
        this.triggerUrl = url;
        return this;
    }

    public BenchmarkBuilder addPreHook(RunHook runHook) {
        this.preHooks.add(runHook);
        return this;
    }

    public BenchmarkBuilder addPostHook(RunHook runHook) {
        this.postHooks.add(runHook);
        return this;
    }

    public BenchmarkBuilder failurePolicy(Benchmark.FailurePolicy policy) {
        this.failurePolicy = policy;
        return this;
    }

    public void prepareBuild() {
        this.plugins.values().forEach(PluginBuilder::prepareBuild);
        this.phaseBuilders.values().forEach(PhaseBuilder::prepareBuild);
    }

    public Benchmark build() {
        this.prepareBuild();
        FutureSupplier<Benchmark> bs = new FutureSupplier<Benchmark>();
        AtomicInteger phaseIdCounter = new AtomicInteger(0);
        Map<String, Phase> phases = this.phaseBuilders.values().stream().flatMap(builder -> builder.build(bs, phaseIdCounter).stream()).collect(Collectors.toMap(Phase::name, p -> p));
        for (Phase phase : phases.values()) {
            this.checkDependencies(phase, phase.startAfter, phases);
            this.checkDependencies(phase, phase.startAfterStrict, phases);
            this.checkDependencies(phase, phase.terminateAfterStrict, phases);
            if (phase.startWithDelay != null) {
                this.checkDependencies(phase, Collections.singletonList(phase.startWithDelay.phase), phases);
            }
            this.checkStartWith(phase);
            this.checkDeadlock(phase, phases);
        }
        HashMap<String, Object> tags = new HashMap<String, Object>();
        this.plugins.values().forEach(builder -> builder.addTags(tags));
        tags.put("threads", this.threads);
        Map<String, byte[]> files = this.data.files();
        Agent[] agents = (Agent[])this.agents.stream().map(a -> {
            HashMap<String, String> properties = new HashMap<String, String>(this.defaultAgentProperties);
            properties.putAll(a.properties);
            return new Agent(a.name, a.inlineConfig, properties);
        }).toArray(Agent[]::new);
        Map<Class<? extends PluginConfig>, PluginConfig> plugins = this.plugins.values().stream().map(PluginBuilder::build).collect(Collectors.toMap((Function<PluginConfig, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lio/hyperfoil/api/config/PluginConfig;)Ljava/lang/Class;)(), Function.identity()));
        Benchmark benchmark = new Benchmark(this.name, Benchmark.randomUUID(), this.source, this.params, files, agents, this.threads, plugins, new ArrayList<Phase>(phases.values()), tags, this.statisticsCollectionPeriod, this.triggerUrl, this.preHooks, this.postHooks, this.failurePolicy);
        bs.set(benchmark);
        return benchmark;
    }

    private void checkDeadlock(Phase phase, Map<String, Phase> phases) {
        HashMap deps = new HashMap();
        ArrayDeque<Phase> toProcess = new ArrayDeque<Phase>();
        toProcess.add(phase);
        while (!toProcess.isEmpty()) {
            Phase p = (Phase)toProcess.poll();
            p.getDependencies().forEach(name -> {
                Phase p2 = (Phase)phases.get(name);
                if (p2 == null) {
                    return;
                }
                if (p2 == phase) {
                    StringBuilder sb = new StringBuilder("Phase dependencies contain cycle: ").append((String)name).append(" > ");
                    Phase p3 = p;
                    do {
                        sb.append(p3.name).append(" > ");
                        p3 = (Phase)deps.get(p3);
                        assert (p3 != null);
                    } while (p3 != phase);
                    throw new BenchmarkDefinitionException(sb.append((String)name).toString());
                }
                if (deps.putIfAbsent(p2, p) == null) {
                    toProcess.add(p2);
                }
            });
        }
    }

    private void checkDependencies(Phase phase, Collection<String> references, Map<String, Phase> phases) {
        for (String dep : references) {
            if (phases.containsKey(dep)) continue;
            String suggestion = phases.keySet().stream().filter(name -> name.toLowerCase().startsWith(dep)).findAny().map(name -> " Did you mean " + name + "?").orElse("");
            throw new BenchmarkDefinitionException("Phase " + dep + " referenced from " + phase.name() + " is not defined." + suggestion);
        }
    }

    private void checkStartWith(Phase phase) {
        if (!(phase.startWithDelay == null || phase.startAfter.isEmpty() && phase.startAfterStrict.isEmpty() && phase.startTime <= 0L)) {
            throw new BenchmarkDefinitionException("Phase " + phase.name + " has both startWith and one of startAfter, startAfterStrict and startTime set.");
        }
    }

    void addPhase(String name, PhaseBuilder phaseBuilder) {
        if (this.phaseBuilders.containsKey(name)) {
            throw new IllegalArgumentException("Phase '" + name + "' already defined.");
        }
        this.phaseBuilders.put(name, phaseBuilder);
    }

    public BenchmarkBuilder statisticsCollectionPeriod(long statisticsCollectionPeriod) {
        this.statisticsCollectionPeriod = statisticsCollectionPeriod;
        return this;
    }

    public BenchmarkData data() {
        return this.data;
    }

    public BenchmarkBuilder data(BenchmarkData data) {
        this.data = data;
        return this;
    }

    public BenchmarkBuilder setDefaultAgentProperties(Map<String, String> properties) {
        this.defaultAgentProperties = properties;
        return this;
    }

    public <T extends PluginBuilder<?>> T plugin(Class<T> clz) {
        return (T)this.plugins.get(clz);
    }

    public <P extends PluginBuilder<?>> P addPlugin(Function<BenchmarkBuilder, P> ctor) {
        PluginBuilder plugin = (PluginBuilder)ctor.apply(this);
        Class<?> pluginClass = plugin.getClass();
        PluginBuilder prev = this.plugins.putIfAbsent(pluginClass, plugin);
        if (prev != null) {
            throw new BenchmarkDefinitionException("Adding the same plugin twice! " + plugin.getClass().getName());
        }
        return (P)plugin;
    }
}

