/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Agent;
import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.PluginConfig;
import io.hyperfoil.api.config.RunHook;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.Visitor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Benchmark
implements Serializable {
    private final String name;
    private final String version;
    private final Map<String, String> params;
    @Visitor.Ignore
    private final BenchmarkSource source;
    @Visitor.Ignore
    private final Map<String, byte[]> files;
    private final Agent[] agents;
    private final int defaultThreads;
    private final int totalThreads;
    @Visitor.Invoke(method="plugins")
    private final Map<Class<? extends PluginConfig>, PluginConfig> plugins;
    private final Collection<Phase> phases;
    private final Map<String, Object> tags;
    private final long statisticsCollectionPeriod;
    private final String triggerUrl;
    private final List<RunHook> preHooks;
    private final List<RunHook> postHooks;
    private final FailurePolicy failurePolicy;

    public static Benchmark forTesting() {
        return BenchmarkBuilder.builder().build();
    }

    public Benchmark(String name, String version, BenchmarkSource source, Map<String, String> params, Map<String, byte[]> files, Agent[] agents, int defaultThreads, Map<Class<? extends PluginConfig>, PluginConfig> plugins, Collection<Phase> phases, Map<String, Object> tags, long statisticsCollectionPeriod, String triggerUrl, List<RunHook> preHooks, List<RunHook> postHooks, FailurePolicy failurePolicy) {
        this.name = name;
        this.params = params;
        this.source = source;
        this.files = files;
        this.agents = agents;
        this.defaultThreads = defaultThreads;
        this.plugins = plugins;
        this.failurePolicy = failurePolicy;
        this.totalThreads = agents.length == 0 ? defaultThreads : Stream.of(agents).mapToInt(Agent::threads).map(n -> n <= 0 ? defaultThreads : n).sum();
        this.phases = phases;
        this.tags = tags;
        this.statisticsCollectionPeriod = statisticsCollectionPeriod;
        this.triggerUrl = triggerUrl;
        this.preHooks = preHooks;
        this.postHooks = postHooks;
        this.version = version;
    }

    static String randomUUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return new UUID(random.nextLong(), random.nextLong()).toString();
    }

    public static Benchmark empty(String name, Map<String, String> templateParams) {
        return new Benchmark(name, Benchmark.randomUUID(), null, templateParams, Collections.emptyMap(), new Agent[0], 0, Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap(), 0L, null, Collections.emptyList(), Collections.emptyList(), FailurePolicy.CANCEL);
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public Agent[] agents() {
        return this.agents;
    }

    public BenchmarkSource source() {
        return this.source;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public Map<String, byte[]> files() {
        return this.files;
    }

    public int defaultThreads() {
        return this.defaultThreads;
    }

    public Collection<Phase> phases() {
        return this.phases;
    }

    public Map<String, Object> tags() {
        return this.tags;
    }

    public long statisticsCollectionPeriod() {
        return this.statisticsCollectionPeriod;
    }

    public String triggerUrl() {
        return this.triggerUrl;
    }

    public List<RunHook> preHooks() {
        return this.preHooks;
    }

    public List<RunHook> postHooks() {
        return this.postHooks;
    }

    public String toString() {
        return "Benchmark{name='" + this.name + "', source='" + String.valueOf(this.source) + "', agents=" + Arrays.toString(this.agents) + ", threads=" + this.defaultThreads + ", plugins=" + String.valueOf(this.plugins) + ", phases=" + String.valueOf(this.phases) + ", tags=" + String.valueOf(this.tags) + ", statisticsCollectionPeriod=" + this.statisticsCollectionPeriod + "}";
    }

    public Stream<Step> steps() {
        return this.phases().stream().flatMap(phase -> Stream.of(phase.scenario().sequences())).flatMap(sequence -> Stream.of(sequence.steps()));
    }

    public Phase[] phasesById() {
        Phase[] phases = new Phase[this.phases.size()];
        this.phases.forEach(p -> {
            phases[p.id()] = p;
        });
        return phases;
    }

    public int slice(int totalValue, int agentId) {
        if (this.agents.length == 0) {
            return totalValue;
        }
        int threads = this.threads(agentId);
        int prevThreads = IntStream.range(0, agentId).map(this::threads).sum();
        return (prevThreads + threads) * totalValue / this.totalThreads - prevThreads * totalValue / this.totalThreads;
    }

    public double slice(double totalValue, int agentId) {
        if (this.agents.length == 0) {
            return totalValue;
        }
        return totalValue * (double)this.threads(agentId) / (double)this.totalThreads;
    }

    public int threads(int agentId) {
        if (this.agents.length == 0) {
            return this.defaultThreads;
        }
        int threads = this.agents()[agentId].threads();
        return threads <= 0 ? this.defaultThreads() : threads;
    }

    public int totalThreads() {
        return this.totalThreads;
    }

    public <T extends PluginConfig> T plugin(Class<T> clazz) {
        return (T)this.plugins.get(clazz);
    }

    public Collection<PluginConfig> plugins() {
        return this.plugins.values();
    }

    public FailurePolicy failurePolicy() {
        return this.failurePolicy;
    }

    public static enum FailurePolicy {
        CANCEL,
        CONTINUE;

    }
}

