/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.collection;

import java.lang.reflect.Array;
import java.util.function.Supplier;

public class Lookup<K, V> {
    final Class<V> clazz;
    final Supplier<V> factory;
    Object[] keys;
    V[] values;
    V[] array;
    int size;

    public Lookup(Class<V> clazz, Supplier<V> factory) {
        this.clazz = clazz;
        this.factory = factory;
        this.keys = new Object[4];
        this.values = this.newArray(4);
    }

    public V get(K key) {
        int mask = this.keys.length - 1;
        int slot = key.hashCode() & mask;
        Object k2;
        while ((k2 = this.keys[slot]) != null) {
            if (k2.equals(key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public V reserve(K key) {
        V existing = this.get(key);
        if (existing != null) {
            return existing;
        }
        if (++this.size * 2 > this.values.length) {
            int newSize = this.keys.length * 2;
            Object[] newKeys = new Object[newSize];
            V[] newValues = this.newArray(newSize);
            int mask = newSize - 1;
            for (int i = 0; i < this.keys.length; ++i) {
                Object k = this.keys[i];
                if (k == null) continue;
                this.insert(newKeys, newValues, mask, k, this.values[i]);
            }
            this.keys = newKeys;
            this.values = newValues;
        }
        V newValue = this.factory.get();
        this.insert(this.keys, this.values, this.keys.length - 1, key, newValue);
        this.array = null;
        return newValue;
    }

    private void insert(Object[] newKeys, V[] newValues, int mask, Object k, V v) {
        Object otherKey;
        int slot = k.hashCode() & mask;
        while ((otherKey = newKeys[slot]) != null) {
            assert (!otherKey.equals(k));
            slot = slot + 1 & mask;
        }
        newKeys[slot] = k;
        newValues[slot] = v;
    }

    private V[] newArray(int size) {
        return (Object[])Array.newInstance(this.clazz, size);
    }

    public V[] array() {
        if (this.array == null) {
            this.array = this.newArray(this.size);
            int i = 0;
            for (V v : this.values) {
                if (v == null) continue;
                this.array[i++] = v;
            }
        }
        return this.array;
    }
}

