/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.collection;

import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LimitedPool<T> {
    private static final Logger log = LogManager.getLogger(LimitedPool.class);
    private final Object[] elements;
    private final int size;
    private final int mask;
    private int index;

    public LimitedPool(int capacity, Supplier<T> init) {
        this.mask = (1 << 32 - Integer.numberOfLeadingZeros(capacity - 1)) - 1;
        this.elements = new Object[this.mask + 1];
        this.size = capacity;
        for (int i = 0; i < capacity; ++i) {
            this.elements[i] = init.get();
        }
    }

    public LimitedPool(T[] array) {
        this.mask = (1 << 32 - Integer.numberOfLeadingZeros(array.length - 1)) - 1;
        this.elements = new Object[this.mask + 1];
        this.size = array.length;
        System.arraycopy(array, 0, this.elements, 0, array.length);
    }

    public void reset(Object[] array) {
        if (array.length != this.size) {
            throw new IllegalArgumentException("Pool should be initialized with " + this.size + " objects (actual: " + array.length + ")");
        }
        System.arraycopy(array, 0, this.elements, 0, array.length);
        Arrays.fill(this.elements, array.length, this.elements.length, null);
    }

    public T acquire() {
        int i = this.index + 1 & this.mask;
        while (i != this.index && this.elements[i] == null) {
            i = i + 1 & this.mask;
        }
        if (this.elements[i] == null) {
            return null;
        }
        this.index = i;
        Object object = this.elements[i];
        this.elements[i] = null;
        return (T)object;
    }

    public void release(T object) {
        int i;
        int stop = this.index + this.mask & this.mask;
        for (i = this.index; i != stop && this.elements[i & this.mask] != null; ++i) {
        }
        if (this.elements[i] != null) {
            for (i = 0; i < this.elements.length; ++i) {
                if (this.elements[i] != object) continue;
                log.error("{} already returned to pool!", object);
                return;
            }
            throw new IllegalStateException("Pool should not be full!");
        }
        this.index = i + this.mask & this.mask;
        this.elements[i] = object;
    }

    public boolean isFull() {
        int currentSize = 0;
        for (Object o : this.elements) {
            if (o == null) continue;
            ++currentSize;
        }
        return currentSize == this.size;
    }

    public boolean isDepleted() {
        for (Object o : this.elements) {
            if (o == null) continue;
            return false;
        }
        return true;
    }
}

