/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.hotrod.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.generators.StringGeneratorBuilder;
import io.hyperfoil.core.generators.StringGeneratorImplBuilder;
import io.hyperfoil.core.metric.MetricSelector;
import io.hyperfoil.core.metric.PathMetricSelector;
import io.hyperfoil.core.metric.ProvidedMetricSelector;
import io.hyperfoil.core.steps.StatisticsStep;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.hotrod.api.HotRodOperation;
import io.hyperfoil.hotrod.resource.HotRodResource;
import io.hyperfoil.hotrod.steps.HotRodOperationBuilder;
import io.hyperfoil.hotrod.steps.HotRodRequestStep;
import io.hyperfoil.hotrod.steps.HotRodResponseStep;
import java.util.Arrays;
import java.util.List;

@Name(value="hotrodRequest")
public class HotRodRequestBuilder
extends BaseStepBuilder<HotRodRequestBuilder> {
    private HotRodOperationBuilder operation;
    private StringGeneratorBuilder cacheName;
    private MetricSelector metricSelector;
    private StringGeneratorBuilder key;
    private StringGeneratorBuilder value;

    public void prepareBuild() {
        if (this.metricSelector == null) {
            String sequenceName = Locator.current().sequence().name();
            this.metricSelector = new ProvidedMetricSelector(sequenceName);
        }
    }

    public List<Step> build() {
        int stepId = StatisticsStep.nextId();
        HotRodResource.Key key = new HotRodResource.Key();
        SerializableFunction keyGenerator = this.key != null ? this.key.build() : null;
        SerializableFunction valueGenerator = this.value != null ? this.value.build() : null;
        HotRodRequestStep step = new HotRodRequestStep(stepId, key, this.operation.build(), (SerializableFunction<Session, String>)this.cacheName.build(), this.metricSelector, (SerializableFunction<Session, String>)keyGenerator, (SerializableFunction<Session, String>)valueGenerator);
        HotRodResponseStep secondHotRodStep = new HotRodResponseStep(key);
        return Arrays.asList(new Step[]{step, secondHotRodStep});
    }

    public HotRodRequestBuilder metric(String name) {
        return this.metric(new ProvidedMetricSelector(name));
    }

    public HotRodRequestBuilder metric(ProvidedMetricSelector selector) {
        this.metricSelector = selector;
        return this;
    }

    public PathMetricSelector metric() {
        PathMetricSelector selector = new PathMetricSelector();
        this.metricSelector = selector;
        return selector;
    }

    public StringGeneratorImplBuilder<HotRodRequestBuilder> cacheName() {
        StringGeneratorImplBuilder builder = new StringGeneratorImplBuilder((Object)this);
        this.cacheName((StringGeneratorBuilder)builder);
        return builder;
    }

    public HotRodRequestBuilder cacheName(StringGeneratorBuilder builder) {
        if (this.cacheName != null) {
            throw new BenchmarkDefinitionException("CacheName generator already set.");
        }
        this.cacheName = builder;
        return this;
    }

    public HotRodRequestBuilder cacheName(String pattern) {
        return (HotRodRequestBuilder)((Object)this.cacheName().pattern(pattern).end());
    }

    public HotRodRequestBuilder operation(HotRodOperation operation) {
        return this.operation(() -> new HotRodOperationBuilder.Provided(operation));
    }

    public HotRodRequestBuilder operation(HotRodOperationBuilder operation) {
        this.operation = operation;
        return this;
    }

    public StringGeneratorImplBuilder<HotRodRequestBuilder> key() {
        StringGeneratorImplBuilder builder = new StringGeneratorImplBuilder((Object)this);
        this.key((StringGeneratorBuilder)builder);
        return builder;
    }

    public HotRodRequestBuilder key(StringGeneratorBuilder builder) {
        if (this.key != null) {
            throw new BenchmarkDefinitionException("Key generator already set.");
        }
        this.key = builder;
        return this;
    }

    public HotRodRequestBuilder key(String pattern) {
        return (HotRodRequestBuilder)((Object)this.key().pattern(pattern).end());
    }

    public StringGeneratorImplBuilder<HotRodRequestBuilder> value() {
        StringGeneratorImplBuilder builder = new StringGeneratorImplBuilder((Object)this);
        this.value((StringGeneratorBuilder)builder);
        return builder;
    }

    public HotRodRequestBuilder value(StringGeneratorBuilder builder) {
        if (this.value != null) {
            throw new BenchmarkDefinitionException("Value generator already set.");
        }
        this.value = builder;
        return this;
    }

    public HotRodRequestBuilder value(String pattern) {
        return (HotRodRequestBuilder)((Object)this.value().pattern(pattern).end());
    }

    public HotRodRequestBuilder put(String cacheName) {
        return this.operation(HotRodOperation.PUT).cacheName(cacheName);
    }

    public HotRodRequestBuilder get(String cacheName) {
        return this.operation(HotRodOperation.GET).cacheName(cacheName);
    }
}

