/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.hotrod.connection;

import io.hyperfoil.hotrod.api.HotRodRemoteCachePool;
import io.hyperfoil.hotrod.config.HotRodCluster;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TransportFactory;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;

public class HotRodRemoteCachePoolImpl
implements HotRodRemoteCachePool {
    private final HotRodCluster[] clusters;
    private final EventLoop eventLoop;
    private final Map<String, RemoteCacheManager> remoteCacheManagers = new HashMap<String, RemoteCacheManager>();
    private final Map<String, RemoteCache<?, ?>> remoteCaches = new HashMap();

    public HotRodRemoteCachePoolImpl(HotRodCluster[] clusters, EventLoop eventLoop) {
        this.clusters = clusters;
        this.eventLoop = eventLoop;
    }

    @Override
    public void start() {
        for (HotRodCluster cluster : this.clusters) {
            ConfigurationBuilder cb = HotRodURI.create((String)cluster.uri()).toConfigurationBuilder();
            Properties properties = new Properties();
            properties.setProperty("infinispan.client.hotrod.default_executor_factory.pool_size", "1");
            cb.asyncExecutorFactory().withExecutorProperties(properties);
            cb.asyncExecutorFactory().factory(p -> this.eventLoop);
            cb.transportFactory((TransportFactory)new FixedEventLoopGroupTransportFactory((EventLoopGroup)this.eventLoop));
            RemoteCacheManager remoteCacheManager = new RemoteCacheManager(cb.build());
            this.remoteCacheManagers.put(cluster.uri(), remoteCacheManager);
            this.validateEventLoop(remoteCacheManager);
            for (String cache : cluster.caches()) {
                this.remoteCaches.put(cache, remoteCacheManager.getCache(cache));
            }
        }
    }

    private void validateEventLoop(RemoteCacheManager remoteCacheManager) {
        try {
            Field dispatcherField = RemoteCacheManager.class.getDeclaredField("dispatcher");
            dispatcherField.setAccessible(true);
            OperationDispatcher dispatcher = (OperationDispatcher)dispatcherField.get(remoteCacheManager);
            EventLoopGroup actualEventLoop = dispatcher.getChannelHandler().getEventLoopGroup();
            if (actualEventLoop != this.eventLoop) {
                throw new IllegalStateException("Event loop was not injected correctly. This is a classpath issue.");
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        ExecutorService asyncExecutorService = remoteCacheManager.getAsyncExecutorService();
        if (asyncExecutorService != this.eventLoop) {
            throw new IllegalStateException("Event loop was not configured correctly.");
        }
    }

    @Override
    public void shutdown() {
        this.remoteCacheManagers.values().forEach(RemoteCacheManager::stop);
    }

    @Override
    public RemoteCacheWithoutToString<?, ?> getRemoteCache(String cacheName) {
        RemoteCache<?, ?> cache = this.remoteCaches.get(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Cache '%s' is not a defined cache", cacheName));
        }
        return new RemoteCacheWithoutToString(cache);
    }

    private static class FixedEventLoopGroupTransportFactory
    implements TransportFactory {
        private final EventLoopGroup eventLoop;

        private FixedEventLoopGroupTransportFactory(EventLoopGroup eventLoop) {
            this.eventLoop = eventLoop;
        }

        public Class<? extends SocketChannel> socketChannelClass() {
            return TransportFactory.DEFAULT.socketChannelClass();
        }

        public EventLoopGroup createEventLoopGroup(int maxExecutors, ExecutorService executorService) {
            return this.eventLoop;
        }
    }

    public static class RemoteCacheWithoutToString<K, V> {
        private final RemoteCache<K, V> remoteCache;

        public RemoteCacheWithoutToString(RemoteCache<K, V> remoteCache) {
            this.remoteCache = remoteCache;
        }

        public CompletableFuture<V> putAsync(K key, V value) {
            return this.remoteCache.putAsync(key, value);
        }

        public CompletableFuture<V> getAsync(K key) {
            return this.remoteCache.getAsync(key);
        }
    }
}

