/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.hotrod.config;

import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.PluginBuilder;
import io.hyperfoil.api.config.PluginConfig;
import io.hyperfoil.hotrod.config.HotRodCluster;
import io.hyperfoil.hotrod.config.HotRodClusterBuilder;
import io.hyperfoil.hotrod.config.HotRodErgonomics;
import io.hyperfoil.hotrod.config.HotRodPluginConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class HotRodPluginBuilder
extends PluginBuilder<HotRodErgonomics> {
    private final List<HotRodClusterBuilder> clusters = new ArrayList<HotRodClusterBuilder>();

    public HotRodPluginBuilder(BenchmarkBuilder parent) {
        super(parent);
    }

    public HotRodErgonomics ergonomics() {
        return null;
    }

    public void prepareBuild() {
    }

    public PluginConfig build() {
        HotRodCluster[] clusters = (HotRodCluster[])this.clusters.stream().map(HotRodClusterBuilder::build).toArray(HotRodCluster[]::new);
        if (clusters.length == 0) {
            throw new BenchmarkDefinitionException("No clusters set!");
        }
        if (Stream.of(clusters).map(HotRodCluster::uri).distinct().count() != (long)clusters.length) {
            throw new BenchmarkDefinitionException("Cluster definition with duplicate uris!");
        }
        return new HotRodPluginConfig(clusters);
    }

    public HotRodClusterBuilder addCluster() {
        HotRodClusterBuilder builder = new HotRodClusterBuilder();
        this.clusters.add(builder);
        return builder;
    }
}

