/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.hotrod;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.api.PluginRunData;
import io.hyperfoil.core.impl.ConnectionStatsConsumer;
import io.hyperfoil.hotrod.api.HotRodRemoteCachePool;
import io.hyperfoil.hotrod.config.HotRodCluster;
import io.hyperfoil.hotrod.config.HotRodPluginConfig;
import io.hyperfoil.hotrod.connection.HotRodRemoteCachePoolImpl;
import io.netty.channel.EventLoop;
import io.vertx.core.Future;
import java.time.Clock;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;

public class HotRodRunData
implements PluginRunData {
    private final HotRodPluginConfig plugin;
    private HotRodRemoteCachePool[] pool;

    public HotRodRunData(Benchmark benchmark, EventLoop[] executors, int agentId) {
        this.plugin = (HotRodPluginConfig)benchmark.plugin(HotRodPluginConfig.class);
        ArrayList<String> allCaches = new ArrayList<String>();
        for (HotRodCluster cluster : this.plugin.clusters()) {
            for (String cacheName : cluster.caches()) {
                if (allCaches.contains(cacheName)) {
                    throw new BenchmarkDefinitionException(String.format("Duplicated cache: %s", cacheName));
                }
                allCaches.add(cacheName);
            }
        }
        this.pool = new HotRodRemoteCachePool[executors.length];
        for (int i = 0; i < executors.length; ++i) {
            this.pool[i] = new HotRodRemoteCachePoolImpl(this.plugin.clusters(), executors[i]);
        }
    }

    public void initSession(Session session, int executorId, Scenario scenario, Clock clock) {
        HotRodRemoteCachePool pollById = this.pool[executorId];
        session.declareSingletonResource(HotRodRemoteCachePool.KEY, (Session.Resource)pollById);
    }

    public void openConnections(Function<Callable<Void>, Future<Void>> blockingHandler, Consumer<Future<Void>> promiseCollector) {
        for (HotRodRemoteCachePool p : this.pool) {
            promiseCollector.accept(blockingHandler.apply(() -> {
                p.start();
                return null;
            }));
        }
    }

    public void listConnections(Consumer<String> connectionCollector) {
    }

    public void visitConnectionStats(ConnectionStatsConsumer consumer) {
    }

    public void shutdown() {
        for (HotRodRemoteCachePool p : this.pool) {
            p.shutdown();
        }
    }
}

