/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.cluster.infinispan.ClusterHealthCheck;
import io.vertx.ext.cluster.infinispan.InfinispanClusterManager;
import io.vertx.ext.healthchecks.Status;
import java.util.List;
import org.infinispan.health.CacheHealth;
import org.infinispan.health.ClusterHealth;
import org.infinispan.health.Health;
import org.infinispan.health.HealthStatus;
import org.infinispan.manager.EmbeddedCacheManager;

public class ClusterHealthCheckImpl
implements ClusterHealthCheck {
    private final Vertx vertx;
    private final boolean detailed;

    public ClusterHealthCheckImpl(Vertx vertx, boolean detailed) {
        this.vertx = vertx;
        this.detailed = detailed;
    }

    public void handle(Promise<Status> promise) {
        VertxInternal vertxInternal = (VertxInternal)this.vertx;
        InfinispanClusterManager clusterManager = (InfinispanClusterManager)vertxInternal.getClusterManager();
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)clusterManager.getCacheContainer();
        Health health = cacheManager.getHealth();
        HealthStatus healthStatus = health.getClusterHealth().getHealthStatus();
        Status status = new Status().setOk(healthStatus == HealthStatus.HEALTHY);
        if (this.detailed) {
            status.setData(this.convert(health));
        }
        promise.complete((Object)status);
    }

    private JsonObject convert(Health health) {
        return new JsonObject().put("clusterHealth", (Object)this.convert(health.getClusterHealth())).put("cacheHealth", (Object)this.convert(health.getCacheHealth()));
    }

    private JsonObject convert(ClusterHealth clusterHealth) {
        return new JsonObject().put("healthStatus", (Object)clusterHealth.getHealthStatus().name()).put("clusterName", (Object)clusterHealth.getClusterName()).put("numberOfNodes", (Object)clusterHealth.getNumberOfNodes()).put("nodeNames", (Object)clusterHealth.getNodeNames().stream().collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
    }

    private JsonArray convert(List<CacheHealth> cacheHealths) {
        return cacheHealths.stream().map(cacheHealth -> new JsonObject().put("cacheName", (Object)cacheHealth.getCacheName()).put("status", (Object)cacheHealth.getStatus().name())).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
    }
}

