/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorCollection;

public class CloseableIteratorCollectionStream<I, O>
implements ReadStream<O> {
    private static final int BATCH_SIZE = 10;
    private final Context context;
    private final Supplier<CloseableIteratorCollection<I>> iterableSupplier;
    private final Function<I, O> converter;
    private CloseableIteratorCollection<I> iterable;
    private CloseableIterator<I> iterator;
    private Deque<I> queue;
    private Handler<O> dataHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;
    private long demand = Long.MAX_VALUE;
    private boolean readInProgress;
    private boolean closed;

    public CloseableIteratorCollectionStream(Context context, Supplier<CloseableIteratorCollection<I>> iterableSupplier, Function<I, O> converter) {
        this.context = context;
        this.iterableSupplier = iterableSupplier;
        this.converter = converter;
    }

    public synchronized CloseableIteratorCollectionStream<I, O> exceptionHandler(Handler<Throwable> handler) {
        this.checkClosed();
        this.exceptionHandler = handler;
        return this;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalArgumentException("Stream is closed");
        }
    }

    public synchronized CloseableIteratorCollectionStream<I, O> handler(Handler<O> handler) {
        this.checkClosed();
        if (handler == null) {
            this.close();
        } else {
            this.dataHandler = handler;
            this.context.executeBlocking(fut -> fut.complete(this.iterableSupplier.get()), false, ar -> {
                CloseableIteratorCollectionStream closeableIteratorCollectionStream = this;
                synchronized (closeableIteratorCollectionStream) {
                    if (ar.succeeded()) {
                        this.iterable = (CloseableIteratorCollection)ar.result();
                        if (this.canRead()) {
                            this.doRead();
                        }
                    } else {
                        this.close();
                        this.handleException(ar.cause());
                    }
                }
            });
        }
        return this;
    }

    private boolean canRead() {
        return this.demand > 0L && !this.closed;
    }

    public synchronized CloseableIteratorCollectionStream<I, O> pause() {
        this.checkClosed();
        this.demand = 0L;
        return this;
    }

    public CloseableIteratorCollectionStream<I, O> fetch(long amount) {
        this.checkClosed();
        if (amount > 0L) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
            if (this.dataHandler != null && this.iterable != null) {
                this.doRead();
            }
        }
        return this;
    }

    public synchronized CloseableIteratorCollectionStream<I, O> resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    private synchronized void doRead() {
        if (this.readInProgress) {
            return;
        }
        this.readInProgress = true;
        if (this.iterator == null) {
            this.context.executeBlocking(fut -> fut.complete((Object)this.iterable.iterator()), false, ar -> {
                CloseableIteratorCollectionStream closeableIteratorCollectionStream = this;
                synchronized (closeableIteratorCollectionStream) {
                    this.readInProgress = false;
                    if (ar.succeeded()) {
                        this.iterator = (CloseableIterator)ar.result();
                        if (this.canRead()) {
                            this.doRead();
                        }
                    } else {
                        this.close();
                        this.handleException(ar.cause());
                    }
                }
            });
            return;
        }
        if (this.queue == null) {
            this.queue = new ArrayDeque<I>(10);
        }
        if (!this.queue.isEmpty()) {
            this.context.runOnContext(v -> this.emitQueued());
            return;
        }
        this.context.executeBlocking(fut -> {
            ArrayList<Object> batch = new ArrayList<Object>(10);
            for (int i = 0; i < 10 && this.iterator.hasNext(); ++i) {
                batch.add(this.iterator.next());
            }
            fut.complete(batch);
        }, false, ar -> {
            CloseableIteratorCollectionStream closeableIteratorCollectionStream = this;
            synchronized (closeableIteratorCollectionStream) {
                if (ar.succeeded()) {
                    this.queue.addAll((Collection)ar.result());
                    if (this.queue.isEmpty()) {
                        this.close();
                        if (this.endHandler != null) {
                            this.endHandler.handle(null);
                        }
                    } else {
                        this.emitQueued();
                    }
                } else {
                    this.close();
                    this.handleException(ar.cause());
                }
            }
        });
    }

    private void handleException(Throwable cause) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle((Object)cause);
        }
    }

    private synchronized void emitQueued() {
        while (!this.queue.isEmpty() && this.canRead()) {
            if (this.demand != Long.MAX_VALUE) {
                --this.demand;
            }
            this.dataHandler.handle(this.converter.apply(this.queue.remove()));
        }
        this.readInProgress = false;
        if (this.canRead()) {
            this.doRead();
        }
    }

    public synchronized CloseableIteratorCollectionStream<I, O> endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    private void close() {
        this.closed = true;
        AtomicReference iteratorRef = new AtomicReference();
        this.context.executeBlocking(fut -> {
            CloseableIteratorCollectionStream closeableIteratorCollectionStream = this;
            synchronized (closeableIteratorCollectionStream) {
                iteratorRef.set(this.iterator);
            }
            CloseableIterator iter = (CloseableIterator)iteratorRef.get();
            if (iter != null) {
                iter.close();
            }
            fut.complete();
        }, false, null);
    }
}

