/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.util.AsciiString;
import org.jgroups.util.MaxOneThreadPerSender;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SubmitToThreadPool;

public class UnbatchOOBBatches
extends MaxOneThreadPerSender {
    @Property(description="If > 0, then batches > max_size will be unbatched, batches <= max_size will be sent up. This ensures that no batch will ever be greater than a given size.")
    protected int max_size;

    @Override
    public boolean process(MessageBatch batch, boolean oob) {
        if (!oob) {
            return super.process(batch, oob);
        }
        if (this.max_size > 0 && batch.size() <= this.max_size) {
            return super.process(batch, oob);
        }
        AsciiString tmp = batch.clusterName();
        byte[] cname = tmp != null ? tmp.chars() : null;
        for (Message msg : batch) {
            this.tp.getThreadPool().execute(new SubmitToThreadPool.SingleMessageHandlerWithClusterName(this, msg, cname));
        }
        batch.clear();
        return true;
    }
}

