/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.ConnectionListener;
import org.jgroups.blocks.cs.Receiver;
import org.jgroups.conf.AttributeType;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeService;
import org.jgroups.util.Util;

@MBean(description="Server used to accept connections from other servers (or clients) and send data to servers")
public abstract class BaseServer
implements Closeable,
ConnectionListener {
    protected final Lock lock = new ReentrantLock();
    protected Address local_addr;
    protected final List<ConnectionListener> conn_listeners = new CopyOnWriteArrayList<ConnectionListener>();
    protected final Map<Address, Connection> conns = new ConcurrentHashMap<Address, Connection>();
    protected final ThreadFactory factory;
    protected SocketFactory socket_factory = new DefaultSocketFactory();
    protected long reaperInterval;
    protected Reaper reaper;
    protected Receiver receiver;
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected Log log = LogFactory.getLog(this.getClass());
    protected InetAddress client_bind_addr;
    protected int client_bind_port;
    protected boolean defer_client_binding;
    @ManagedAttribute(description="Time (ms) after which an idle connection is closed. 0 disables connection reaping", writable=true, type=AttributeType.TIME)
    protected long conn_expire_time;
    @ManagedAttribute(description="Size (bytes) of the receive channel/socket", writable=true, type=AttributeType.BYTES)
    protected int recv_buf_size;
    @ManagedAttribute(description="Size (bytes) of the send channel/socket", writable=true, type=AttributeType.BYTES)
    protected int send_buf_size;
    @ManagedAttribute(description="The max number of bytes a message can have. If greater, an exception will be thrown. 0 disables this", writable=true, type=AttributeType.BYTES)
    protected int max_length;
    @ManagedAttribute(description="When A connects to B, B reuses the same TCP connection to send data to A")
    protected boolean use_peer_connections;
    @ManagedAttribute(description="Wait for an ack from the server when a connection is established, and retry connection establishment until a valid connection has been established, or the connection to the peer cannot be established (https://issues.redhat.com/browse/JGRP-2684)", writable=true)
    @Deprecated(since="5.4.4", forRemoval=true)
    protected boolean use_acks;
    @ManagedAttribute(description="Log a stack trace when a connection is closed")
    protected boolean log_details = true;
    protected int sock_conn_timeout = 1000;
    protected boolean tcp_nodelay = false;
    protected int linger = -1;
    protected TimeService time_service;

    protected BaseServer(ThreadFactory f, SocketFactory sf, int recv_buf_size) {
        this.factory = f;
        this.recv_buf_size = recv_buf_size;
        if (sf != null) {
            this.socket_factory = sf;
        }
    }

    public Receiver receiver() {
        return this.receiver;
    }

    public BaseServer receiver(Receiver r) {
        this.receiver = r;
        return this;
    }

    public long reaperInterval() {
        return this.reaperInterval;
    }

    public BaseServer reaperInterval(long interval) {
        this.reaperInterval = interval;
        return this;
    }

    public Log log() {
        return this.log;
    }

    public BaseServer log(Log the_log) {
        this.log = the_log;
        return this;
    }

    public Address localAddress() {
        return this.local_addr;
    }

    public InetAddress clientBindAddress() {
        return this.client_bind_addr;
    }

    public BaseServer clientBindAddress(InetAddress addr) {
        this.client_bind_addr = addr;
        return this;
    }

    public int clientBindPort() {
        return this.client_bind_port;
    }

    public BaseServer clientBindPort(int port) {
        this.client_bind_port = port;
        return this;
    }

    public boolean deferClientBinding() {
        return this.defer_client_binding;
    }

    public BaseServer deferClientBinding(boolean defer) {
        this.defer_client_binding = defer;
        return this;
    }

    public SocketFactory socketFactory() {
        return this.socket_factory;
    }

    public BaseServer socketFactory(SocketFactory factory) {
        this.socket_factory = factory;
        return this;
    }

    public boolean usePeerConnections() {
        return this.use_peer_connections;
    }

    public BaseServer usePeerConnections(boolean flag) {
        this.use_peer_connections = flag;
        return this;
    }

    public static boolean useAcks() {
        return false;
    }

    public BaseServer useAcks(boolean ignored) {
        return this;
    }

    public boolean logDetails() {
        return this.log_details;
    }

    public BaseServer logDetails(boolean l) {
        this.log_details = l;
        return this;
    }

    public int socketConnectionTimeout() {
        return this.sock_conn_timeout;
    }

    public BaseServer socketConnectionTimeout(int timeout) {
        this.sock_conn_timeout = timeout;
        return this;
    }

    public long connExpireTime() {
        return this.conn_expire_time;
    }

    public BaseServer connExpireTimeout(long t) {
        this.conn_expire_time = TimeUnit.NANOSECONDS.convert(t, TimeUnit.MILLISECONDS);
        return this;
    }

    public TimeService timeService() {
        return this.time_service;
    }

    public BaseServer timeService(TimeService ts) {
        this.time_service = ts;
        return this;
    }

    public int receiveBufferSize() {
        return this.recv_buf_size;
    }

    public BaseServer receiveBufferSize(int recv_buf_size) {
        this.recv_buf_size = recv_buf_size;
        return this;
    }

    public int sendBufferSize() {
        return this.send_buf_size;
    }

    public BaseServer sendBufferSize(int send_buf_size) {
        this.send_buf_size = send_buf_size;
        return this;
    }

    public int getMaxLength() {
        return this.max_length;
    }

    public BaseServer setMaxLength(int len) {
        this.max_length = len;
        return this;
    }

    public int linger() {
        return this.linger;
    }

    public BaseServer linger(int linger) {
        this.linger = linger;
        return this;
    }

    public boolean tcpNodelay() {
        return this.tcp_nodelay;
    }

    public BaseServer tcpNodelay(boolean tcp_nodelay) {
        this.tcp_nodelay = tcp_nodelay;
        return this;
    }

    @ManagedAttribute(description="True if the server is running, else false")
    public boolean running() {
        return this.running.get();
    }

    @ManagedAttribute(description="Number of connections")
    public int getNumConnections() {
        return this.conns.size();
    }

    @ManagedAttribute(description="Number of currently open connections")
    public int getNumOpenConnections() {
        int retval = 0;
        for (Connection conn : this.conns.values()) {
            if (conn.isClosed()) continue;
            ++retval;
        }
        return retval;
    }

    public void start() throws Exception {
        if (!(this.reaperInterval <= 0L || this.reaper != null && this.reaper.isAlive())) {
            this.reaper = new Reaper();
            this.reaper.start();
        }
    }

    public void stop() {
        Util.close((Closeable)this.reaper);
        this.reaper = null;
        this.lock.lock();
        try {
            for (Connection c : this.conns.values()) {
                Util.close((Closeable)c);
            }
            this.conns.clear();
        }
        finally {
            this.lock.unlock();
        }
        this.conn_listeners.clear();
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    public void flush(Address dest) {
        if (dest != null) {
            this.lock.lock();
            try {
                Connection conn = this.conns.get(dest);
                if (conn != null) {
                    conn.flush();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void flushAll() {
        this.lock.lock();
        try {
            for (Connection c : this.conns.values()) {
                c.flush();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void receive(Address sender, byte[] data, int offset, int length) {
        if (this.receiver != null) {
            this.receiver.receive(sender, data, offset, length);
        }
    }

    public void receive(Address sender, ByteBuffer buf) {
        if (this.receiver != null) {
            this.receiver.receive(sender, buf);
        }
    }

    public void receive(Address sender, DataInput in, int len) throws Exception {
        if (this.max_length > 0 && len > this.max_length) {
            throw new IllegalStateException(String.format("the length of a message (%s) from %s is bigger than the max accepted length (%s): discarding the message", Util.printBytes(len), sender, Util.printBytes(this.max_length)));
        }
        if (this.receiver != null) {
            this.receiver.receive(sender, in, len);
        } else {
            byte[] buf = new byte[len];
            in.readFully(buf, 0, len);
        }
    }

    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        if (!this.validateArgs(dest, data)) {
            return;
        }
        if (dest == null) {
            this.sendToAll(data, offset, length);
            return;
        }
        if (dest.equals(this.local_addr)) {
            this.receive(dest, data, offset, length);
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(dest);
            conn.send(data, offset, length);
        }
        catch (Exception ex) {
            this.removeConnectionIfPresent(dest, conn);
            throw ex;
        }
    }

    public void send(Address dest, ByteBuffer data) throws Exception {
        if (!this.validateArgs(dest, data)) {
            return;
        }
        if (dest == null) {
            this.sendToAll(data);
            return;
        }
        if (dest.equals(this.local_addr)) {
            this.receive(dest, data);
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(dest);
            conn.send(data);
        }
        catch (Exception ex) {
            this.removeConnectionIfPresent(dest, conn);
            throw ex;
        }
    }

    @Override
    public void connectionClosed(Connection conn) {
        this.removeConnectionIfPresent(conn.peerAddress(), conn);
    }

    @Override
    public void connectionEstablished(Connection conn) {
    }

    protected abstract Connection createConnection(Address var1) throws Exception;

    public boolean hasConnection(Address address) {
        return this.conns.containsKey(address);
    }

    public boolean connectionEstablishedTo(Address address) {
        return BaseServer.connected(this.conns.get(address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(Address dest) throws Exception {
        Connection conn = this.conns.get(dest);
        if (BaseServer.connected(conn)) {
            return conn;
        }
        this.lock.lock();
        try {
            conn = this.conns.get(dest);
            if (BaseServer.connected(conn)) {
                Connection connection = conn;
                return connection;
            }
            conn = this.createConnection(dest);
            this.replaceConnection(dest, conn);
            try {
                this.log.trace("%s: connecting to %s", this.local_addr, dest);
                conn.connect(dest);
                this.notifyConnectionEstablished(conn);
                conn.start();
            }
            catch (Exception connect_ex) {
                this.log.trace("%s: failed connecting to %s: %s", this.local_addr, dest, connect_ex);
                this.removeConnectionIfPresent(dest, conn);
                throw connect_ex;
            }
        }
        finally {
            this.lock.unlock();
        }
        return conn;
    }

    public void replaceConnection(Address address, Connection conn) {
        Connection previous = this.conns.put(address, conn);
        if (previous != null) {
            previous.flush();
            Util.close((Closeable)previous);
        }
    }

    public void closeConnection(Connection conn) {
        this.closeConnection(conn, true);
    }

    public void closeConnection(Connection conn, boolean notify) {
        Util.close((Closeable)conn);
        if (notify) {
            this.notifyConnectionClosed(conn);
        }
        this.removeConnectionIfPresent(conn != null ? conn.peerAddress() : null, conn);
    }

    public boolean closeConnection(Address addr) {
        return this.closeConnection(addr, true);
    }

    public boolean closeConnection(Address addr, boolean notify) {
        Connection c;
        if (addr != null && (c = this.conns.get(addr)) != null) {
            this.closeConnection(c, notify);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Address peer_addr, Connection conn) throws Exception {
        this.lock.lock();
        try {
            boolean replace;
            boolean conn_exists = this.hasConnection(peer_addr);
            boolean bl = replace = conn_exists && this.local_addr.compareTo(peer_addr) < 0;
            if (!conn_exists || replace) {
                this.replaceConnection(peer_addr, conn);
                conn.start();
            } else {
                this.log.trace("%s: rejected connection from %s %s", this.local_addr, peer_addr, BaseServer.explanation(conn_exists, replace));
                Util.close((Closeable)conn);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseServer addConnectionListener(ConnectionListener cl) {
        if (cl == null) {
            return this;
        }
        List<ConnectionListener> list = this.conn_listeners;
        synchronized (list) {
            if (!this.conn_listeners.contains(cl)) {
                this.conn_listeners.add(cl);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseServer removeConnectionListener(ConnectionListener cl) {
        if (cl == null) {
            return this;
        }
        List<ConnectionListener> list = this.conn_listeners;
        synchronized (list) {
            this.conn_listeners.remove(cl);
        }
        return this;
    }

    @ManagedOperation(description="Prints all connections")
    public String printConnections() {
        StringBuilder sb = new StringBuilder("\n");
        for (Map.Entry<Address, Connection> entry : this.conns.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionIfPresent(Address address, Connection conn) {
        if (address == null || conn == null) {
            return;
        }
        Connection tmp = null;
        this.lock.lock();
        try {
            Connection existing = this.conns.get(address);
            if (conn == existing) {
                tmp = this.conns.remove(address);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (tmp != null) {
            this.log.trace("%s: removed connection to %s", this.local_addr, address);
            Util.close((Closeable)tmp);
        }
    }

    public void clearConnections() {
        this.lock.lock();
        try {
            this.conns.values().forEach(Util::close);
            this.conns.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void forAllConnections(BiConsumer<Address, Connection> c) {
        this.conns.forEach(c);
    }

    public void retainAll(Collection<Address> current_mbrs) {
        if (current_mbrs == null) {
            return;
        }
        HashMap<Address, Connection> copy = null;
        this.lock.lock();
        try {
            copy = new HashMap<Address, Connection>(this.conns);
            this.conns.keySet().retainAll(current_mbrs);
        }
        finally {
            this.lock.unlock();
        }
        copy.keySet().removeAll(current_mbrs);
        for (Map.Entry entry : copy.entrySet()) {
            Util.close((Closeable)entry.getValue());
        }
        copy.clear();
    }

    public void notifyConnectionClosed(Connection conn) {
        for (ConnectionListener l : this.conn_listeners) {
            try {
                l.connectionClosed(conn);
            }
            catch (Throwable t) {
                this.log.warn("failed notifying listener %s of connection close: %s", l, t);
            }
        }
    }

    public void notifyConnectionEstablished(Connection conn) {
        for (ConnectionListener l : this.conn_listeners) {
            try {
                l.connectionEstablished(conn);
            }
            catch (Throwable t) {
                this.log.warn("failed notifying listener %s of connection establishment: %s", l, t);
            }
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean details) {
        String s = String.format("%s (%s, %d conns)", this.getClass().getSimpleName(), this.local_addr, this.conns.size());
        if (details && !this.conns.isEmpty()) {
            String tmp = this.conns.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), e.getValue())).collect(Collectors.joining("\n"));
            return String.format("%s:\n%s", s, tmp);
        }
        return s;
    }

    public void sendToAll(byte[] data, int offset, int length) {
        for (Map.Entry<Address, Connection> entry : this.conns.entrySet()) {
            Connection conn = entry.getValue();
            try {
                conn.send(data, offset, length);
            }
            catch (Throwable ex) {
                Address dest = entry.getKey();
                this.removeConnectionIfPresent(dest, conn);
                this.log.error("failed sending data to %s: %s", dest, ex);
            }
        }
    }

    public void sendToAll(ByteBuffer data) {
        for (Map.Entry<Address, Connection> entry : this.conns.entrySet()) {
            Connection conn = entry.getValue();
            try {
                conn.send(data.duplicate());
            }
            catch (Throwable ex) {
                Address dest = entry.getKey();
                this.removeConnectionIfPresent(dest, conn);
                this.log.error("failed sending data to %s: %s", dest, ex);
            }
        }
    }

    protected static boolean connected(Connection c) {
        return c != null && !c.isClosed() && (c.isConnected() || c.isConnectionPending());
    }

    protected static Address localAddress(InetAddress bind_addr, int local_port, InetAddress external_addr, int external_port) {
        if (external_addr != null) {
            return new IpAddress(external_addr, external_port > 0 ? external_port : local_port);
        }
        return bind_addr != null ? new IpAddress(bind_addr, local_port) : new IpAddress(local_port);
    }

    protected <T> boolean validateArgs(Address dest, T buffer) {
        if (buffer == null) {
            this.log.warn("%s: data is null; discarding message to %s", this.local_addr, dest);
            return false;
        }
        if (!this.running.get()) {
            this.log.trace("%s: server is not running, discarding message to %s", this.local_addr, dest);
            return false;
        }
        return true;
    }

    protected static String explanation(boolean connection_existed, boolean replace) {
        StringBuilder sb = new StringBuilder();
        if (connection_existed) {
            sb.append(" (connection existed");
            if (replace) {
                sb.append(" but was replaced because my address is lower)");
            } else {
                sb.append(" and my address won as it's higher)");
            }
        } else {
            sb.append(" (connection didn't exist)");
        }
        return sb.toString();
    }

    protected class Reaper
    implements Runnable,
    Closeable {
        private Thread thread;

        protected Reaper() {
        }

        public synchronized void start() {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = BaseServer.this.factory.newThread(new Reaper(), "Reaper");
                this.thread.start();
            }
        }

        public synchronized void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
                try {
                    this.thread.join(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.thread = null;
        }

        @Override
        public void close() throws IOException {
            this.stop();
        }

        public synchronized boolean isAlive() {
            return this.thread != null && this.thread.isDaemon();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                BaseServer.this.lock.lock();
                try {
                    Iterator<Map.Entry<Address, Connection>> it = BaseServer.this.conns.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Address, Connection> entry = it.next();
                        Connection c = entry.getValue();
                        if (!c.isExpired(System.nanoTime())) continue;
                        Util.close((Closeable)c);
                        it.remove();
                    }
                }
                finally {
                    BaseServer.this.lock.unlock();
                }
                Util.sleep(BaseServer.this.reaperInterval);
            }
        }
    }
}

