/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.BaseMessage;
import org.jgroups.Message;
import org.jgroups.util.ByteArray;
import org.jgroups.util.Util;

public class NioMessage
extends BaseMessage {
    protected ByteBuffer buf;
    protected boolean use_direct_memory_for_allocations;

    public NioMessage() {
    }

    public NioMessage(Address dest) {
        super(dest);
    }

    public NioMessage(Address dest, ByteBuffer buf) {
        super(dest);
        this.buf = buf;
    }

    public ByteBuffer getBuf() {
        return this.buf;
    }

    public NioMessage setBuf(ByteBuffer b) {
        this.buf = b;
        return this;
    }

    @Override
    public Supplier<Message> create() {
        return NioMessage::new;
    }

    @Override
    public short getType() {
        return 1;
    }

    public boolean useDirectMemory() {
        return this.use_direct_memory_for_allocations;
    }

    public NioMessage useDirectMemory(boolean b) {
        this.use_direct_memory_for_allocations = b;
        return this;
    }

    @Override
    public boolean hasPayload() {
        return this.buf != null;
    }

    @Override
    public boolean hasArray() {
        return this.buf != null && this.buf.hasArray();
    }

    public boolean isDirect() {
        return this.buf != null && this.buf.isDirect();
    }

    @Override
    public int getOffset() {
        return this.hasArray() ? this.buf.arrayOffset() + this.buf.position() : 0;
    }

    @Override
    public int getLength() {
        return this.buf != null ? this.buf.remaining() : 0;
    }

    @Override
    public byte[] getArray() {
        return this.buf != null ? (this.isDirect() ? Util.bufferToArray(this.buf) : this.buf.array()) : null;
    }

    @Override
    public NioMessage setArray(byte[] b, int offset, int length) {
        if (b != null) {
            this.buf = this.createBuffer(b, offset, length);
        }
        return this;
    }

    @Override
    public NioMessage setArray(ByteArray b) {
        if (b != null) {
            this.buf = this.createBuffer(b.getArray(), b.getOffset(), b.getLength());
        }
        return this;
    }

    @Override
    public <T> T getObject() {
        return this.getObject(null);
    }

    public <T> T getObject(ClassLoader loader) {
        if (this.buf == null) {
            return null;
        }
        try {
            return (T)(this.isFlagSet(Message.Flag.SERIALIZED) ? (Object)Util.objectFromByteBuffer(this.buf, loader) : this.getArray());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public NioMessage setObject(Object obj) {
        this.clearFlag(Message.Flag.SERIALIZED);
        if (obj == null) {
            this.buf = null;
            return this;
        }
        if (obj instanceof byte[]) {
            return this.setArray((byte[])obj, 0, ((byte[])obj).length);
        }
        if (obj instanceof ByteArray) {
            return this.setArray((ByteArray)obj);
        }
        if (obj instanceof ByteBuffer) {
            return this.setBuf((ByteBuffer)obj);
        }
        try {
            ByteArray tmp = Util.objectToBuffer(obj);
            this.setFlag(Message.Flag.SERIALIZED);
            return this.setArray(tmp);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public NioMessage copy(boolean copy_payload, boolean copy_headers) {
        NioMessage retval = (NioMessage)super.copy(copy_payload, copy_headers);
        retval.useDirectMemory(this.use_direct_memory_for_allocations);
        return retval;
    }

    @Override
    public String toString() {
        return String.format("%s %s", super.toString(), this.use_direct_memory_for_allocations ? "(direct)" : "");
    }

    @Override
    protected Message copyPayload(Message copy) {
        if (this.buf != null) {
            ((NioMessage)copy).buf = this.buf.duplicate();
        }
        return copy;
    }

    @Override
    protected int payloadSize() {
        return 4 + this.getLength() + 1;
    }

    @Override
    public void writePayload(DataOutput out) throws IOException {
        out.writeBoolean(this.use_direct_memory_for_allocations);
        out.writeInt(this.buf != null ? this.getLength() : -1);
        if (this.buf != null) {
            if (this.buf.hasArray()) {
                byte[] buffer = this.buf.array();
                int offset = this.buf.arrayOffset() + this.buf.position();
                int length = this.buf.remaining();
                out.write(buffer, offset, length);
            } else {
                ByteBuffer copy = this.buf.duplicate();
                byte[] transfer_buf = new byte[Math.max(copy.remaining() / 10, 128)];
                while (copy.remaining() > 0) {
                    int bytes = Math.min(transfer_buf.length, copy.remaining());
                    copy.get(transfer_buf, 0, bytes);
                    out.write(transfer_buf, 0, bytes);
                }
            }
        }
    }

    @Override
    public void readPayload(DataInput in) throws IOException {
        this.use_direct_memory_for_allocations = in.readBoolean();
        int len = in.readInt();
        if (len < 0) {
            return;
        }
        byte[] tmp = new byte[len];
        in.readFully(tmp, 0, tmp.length);
        this.buf = this.createBuffer(tmp, 0, tmp.length);
    }

    protected ByteBuffer createBuffer(byte[] array, int offset, int length) {
        return this.use_direct_memory_for_allocations ? Util.wrapDirect(array, offset, length) : ByteBuffer.wrap(array, offset, length);
    }
}

