/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.exceptions;

import io.hotmoka.exceptions.UncheckedException;
import io.hotmoka.exceptions.functions.SupplierWithExceptions;
import io.hotmoka.exceptions.functions.SupplierWithExceptions1;
import io.hotmoka.exceptions.functions.SupplierWithExceptions2;
import io.hotmoka.exceptions.functions.SupplierWithExceptions3;
import io.hotmoka.exceptions.functions.SupplierWithExceptions4;
import io.hotmoka.exceptions.functions.SupplierWithExceptions5;
import io.hotmoka.exceptions.functions.SupplierWithExceptions6;
import io.hotmoka.exceptions.functions.SupplierWithExceptions7;
import java.util.function.Supplier;

public abstract class UncheckSupplier {
    private UncheckSupplier() {
    }

    public static <T> Supplier<T> uncheck(final SupplierWithExceptions<? extends T> wrapped) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return wrapped.get();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new UncheckedException(e);
                }
            }
        };
    }

    public static <T, E extends Throwable> Supplier<T> uncheck(final Class<E> exception, final SupplierWithExceptions1<? extends T, E> wrapped) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return wrapped.get();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> Supplier<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final SupplierWithExceptions2<? extends T, E1, E2> wrapped) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return wrapped.get();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> Supplier<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final SupplierWithExceptions3<? extends T, E1, E2, E3> wrapped) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return wrapped.get();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> Supplier<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final SupplierWithExceptions4<? extends T, E1, E2, E3, E4> wrapped) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return wrapped.get();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable> Supplier<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final SupplierWithExceptions5<? extends T, E1, E2, E3, E4, E5> wrapped) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return wrapped.get();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> Supplier<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final Class<E6> exception6, final SupplierWithExceptions6<? extends T, E1, E2, E3, E4, E5, E6> wrapped) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return wrapped.get();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e) || exception6.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable, E7 extends Throwable> Supplier<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final Class<E6> exception6, final Class<E7> exception7, final SupplierWithExceptions7<? extends T, E1, E2, E3, E4, E5, E6, E7> wrapped) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return wrapped.get();
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e) || exception6.isInstance(e) || exception7.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }
}

