/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.exceptions;

import io.hotmoka.exceptions.UncheckedException;
import io.hotmoka.exceptions.functions.PredicateWithExceptions;
import io.hotmoka.exceptions.functions.PredicateWithExceptions1;
import io.hotmoka.exceptions.functions.PredicateWithExceptions2;
import io.hotmoka.exceptions.functions.PredicateWithExceptions3;
import io.hotmoka.exceptions.functions.PredicateWithExceptions4;
import io.hotmoka.exceptions.functions.PredicateWithExceptions5;
import io.hotmoka.exceptions.functions.PredicateWithExceptions6;
import io.hotmoka.exceptions.functions.PredicateWithExceptions7;
import java.util.function.Predicate;

public abstract class UncheckPredicate {
    private UncheckPredicate() {
    }

    public static <T> Predicate<T> uncheck(final PredicateWithExceptions<? super T> wrapped) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                try {
                    return wrapped.test(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new UncheckedException(e);
                }
            }
        };
    }

    public static <T, E extends Throwable> Predicate<T> uncheck(final Class<E> exception, final PredicateWithExceptions1<? super T, E> wrapped) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                try {
                    return wrapped.test(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> Predicate<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final PredicateWithExceptions2<? super T, E1, E2> wrapped) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                try {
                    return wrapped.test(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> Predicate<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final PredicateWithExceptions3<? super T, E1, E2, E3> wrapped) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                try {
                    return wrapped.test(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> Predicate<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final PredicateWithExceptions4<? super T, E1, E2, E3, E4> wrapped) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                try {
                    return wrapped.test(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable> Predicate<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final PredicateWithExceptions5<? super T, E1, E2, E3, E4, E5> wrapped) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                try {
                    return wrapped.test(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> Predicate<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final Class<E6> exception6, final PredicateWithExceptions6<? super T, E1, E2, E3, E4, E5, E6> wrapped) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                try {
                    return wrapped.test(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e) || exception6.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable, E7 extends Throwable> Predicate<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final Class<E6> exception6, final Class<E7> exception7, final PredicateWithExceptions7<? super T, E1, E2, E3, E4, E5, E6, E7> wrapped) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                try {
                    return wrapped.test(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e) || exception6.isInstance(e) || exception7.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }
}

