/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.exceptions;

import io.hotmoka.exceptions.UncheckedException;
import io.hotmoka.exceptions.functions.FunctionWithExceptions;
import io.hotmoka.exceptions.functions.FunctionWithExceptions1;
import io.hotmoka.exceptions.functions.FunctionWithExceptions2;
import io.hotmoka.exceptions.functions.FunctionWithExceptions3;
import io.hotmoka.exceptions.functions.FunctionWithExceptions4;
import io.hotmoka.exceptions.functions.FunctionWithExceptions5;
import io.hotmoka.exceptions.functions.FunctionWithExceptions6;
import io.hotmoka.exceptions.functions.FunctionWithExceptions7;
import java.util.function.Function;

public abstract class UncheckFunction {
    private UncheckFunction() {
    }

    public static <T, R> Function<T, R> uncheck(final FunctionWithExceptions<? super T, ? extends R> wrapped) {
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return wrapped.apply(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new UncheckedException(e);
                }
            }
        };
    }

    public static <T, R, E extends Throwable> Function<T, R> uncheck(final Class<E> exception, final FunctionWithExceptions1<? super T, ? extends R, E> wrapped) {
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return wrapped.apply(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, R, E1 extends Throwable, E2 extends Throwable> Function<T, R> uncheck(final Class<E1> exception1, final Class<E2> exception2, final FunctionWithExceptions2<? super T, ? extends R, E1, E2> wrapped) {
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return wrapped.apply(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, R, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> Function<T, R> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final FunctionWithExceptions3<? super T, ? extends R, E1, E2, E3> wrapped) {
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return wrapped.apply(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, R, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> Function<T, R> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final FunctionWithExceptions4<? super T, ? extends R, E1, E2, E3, E4> wrapped) {
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return wrapped.apply(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, R, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable> Function<T, R> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final FunctionWithExceptions5<? super T, ? extends R, E1, E2, E3, E4, E5> wrapped) {
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return wrapped.apply(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, R, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> Function<T, R> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final Class<E6> exception6, final FunctionWithExceptions6<? super T, ? extends R, E1, E2, E3, E4, E5, E6> wrapped) {
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return wrapped.apply(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e) || exception6.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, R, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable, E7 extends Throwable> Function<T, R> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final Class<E6> exception6, final Class<E7> exception7, final FunctionWithExceptions7<? super T, ? extends R, E1, E2, E3, E4, E5, E6, E7> wrapped) {
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                try {
                    return wrapped.apply(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e) || exception6.isInstance(e) || exception7.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }
}

