/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.exceptions;

import io.hotmoka.exceptions.UncheckedException;
import io.hotmoka.exceptions.functions.ConsumerWithExceptions;
import io.hotmoka.exceptions.functions.ConsumerWithExceptions1;
import io.hotmoka.exceptions.functions.ConsumerWithExceptions2;
import io.hotmoka.exceptions.functions.ConsumerWithExceptions3;
import io.hotmoka.exceptions.functions.ConsumerWithExceptions4;
import io.hotmoka.exceptions.functions.ConsumerWithExceptions5;
import io.hotmoka.exceptions.functions.ConsumerWithExceptions6;
import io.hotmoka.exceptions.functions.ConsumerWithExceptions7;
import java.util.function.Consumer;

public abstract class UncheckConsumer {
    private UncheckConsumer() {
    }

    public static <T> Consumer<T> uncheck(final ConsumerWithExceptions<? super T> wrapped) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    wrapped.accept(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new UncheckedException(e);
                }
            }
        };
    }

    public static <T, E extends Throwable> Consumer<T> uncheck(final Class<E> exception, final ConsumerWithExceptions1<? super T, E> wrapped) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    wrapped.accept(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> Consumer<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final ConsumerWithExceptions2<? super T, E1, E2> wrapped) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    wrapped.accept(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> Consumer<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final ConsumerWithExceptions3<? super T, E1, E2, E3> wrapped) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    wrapped.accept(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> Consumer<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final ConsumerWithExceptions4<? super T, E1, E2, E3, E4> wrapped) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    wrapped.accept(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable> Consumer<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final ConsumerWithExceptions5<? super T, E1, E2, E3, E4, E5> wrapped) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    wrapped.accept(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> Consumer<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final Class<E6> exception6, final ConsumerWithExceptions6<? super T, E1, E2, E3, E4, E5, E6> wrapped) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    wrapped.accept(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e) || exception6.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable, E7 extends Throwable> Consumer<T> uncheck(final Class<E1> exception1, final Class<E2> exception2, final Class<E3> exception3, final Class<E4> exception4, final Class<E5> exception5, final Class<E6> exception6, final Class<E7> exception7, final ConsumerWithExceptions7<? super T, E1, E2, E3, E4, E5, E6, E7> wrapped) {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    wrapped.accept(t);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (exception1.isInstance(e) || exception2.isInstance(e) || exception3.isInstance(e) || exception4.isInstance(e) || exception5.isInstance(e) || exception6.isInstance(e) || exception7.isInstance(e)) {
                        throw new UncheckedException(e);
                    }
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        };
    }
}

