/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.platform.login;

import io.holunda.camunda.platform.login.CamundaLoginAutoConfiguration;
import io.holunda.camunda.platform.login.CamundaLoginAutoConfigurationKt;
import io.holunda.camunda.platform.login.CamundaLoginProperties;
import io.holunda.camunda.platform.login.ExtendedContainerBasedAuthenticationFilter;
import io.holunda.camunda.platform.login.SessionBasedAuthenticationProvider;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.spring.boot.starter.util.SpringBootProcessEnginePlugin;
import org.camunda.bpm.webapp.impl.security.auth.ContainerBasedAuthenticationFilter;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={CamundaLoginProperties.class})
@ConditionalOnProperty(value={"camunda.bpm.login.enabled"}, havingValue="true", matchIfMissing=false)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\r"}, d2={"Lio/holunda/camunda/platform/login/CamundaLoginAutoConfiguration;", "", "<init>", "()V", "reportActivation", "", "containerBasedAuthenticationFilterRegistrationBean", "Lorg/springframework/boot/web/servlet/FilterRegistrationBean;", "Lorg/camunda/bpm/webapp/impl/security/auth/ContainerBasedAuthenticationFilter;", "camundaLoginProperties", "Lio/holunda/camunda/platform/login/CamundaLoginProperties;", "createMissingUserForAutoLoginPlugin", "Lorg/camunda/bpm/spring/boot/starter/util/SpringBootProcessEnginePlugin;", "camunda-platform-7-autologin"})
public final class CamundaLoginAutoConfiguration {
    @PostConstruct
    public final void reportActivation() {
        CamundaLoginAutoConfigurationKt.access$getLogger$p().warn(CamundaLoginAutoConfiguration::reportActivation$lambda$0);
    }

    @Bean
    @NotNull
    public final FilterRegistrationBean<ContainerBasedAuthenticationFilter> containerBasedAuthenticationFilterRegistrationBean(@NotNull CamundaLoginProperties camundaLoginProperties) {
        FilterRegistrationBean filterRegistrationBean;
        Intrinsics.checkNotNullParameter((Object)camundaLoginProperties, (String)"camundaLoginProperties");
        FilterRegistrationBean $this$containerBasedAuthenticationFilterRegistrationBean_u24lambda_u241 = filterRegistrationBean = new FilterRegistrationBean();
        boolean bl = false;
        $this$containerBasedAuthenticationFilterRegistrationBean_u24lambda_u241.setFilter((Filter)new ExtendedContainerBasedAuthenticationFilter(new SessionBasedAuthenticationProvider(camundaLoginProperties.getUserId())));
        $this$containerBasedAuthenticationFilterRegistrationBean_u24lambda_u241.setInitParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"authentication-provider", (Object)SessionBasedAuthenticationProvider.Companion.getFQN())));
        String[] stringArray = new String[]{camundaLoginProperties.getCamundaContextPath() + "/app/*", camundaLoginProperties.getCamundaContextPath() + "/api/*"};
        $this$containerBasedAuthenticationFilterRegistrationBean_u24lambda_u241.addUrlPatterns(stringArray);
        $this$containerBasedAuthenticationFilterRegistrationBean_u24lambda_u241.setDispatcherTypes(EnumSet.of((Enum)DispatcherType.REQUEST));
        return filterRegistrationBean;
    }

    @Bean
    @NotNull
    public final SpringBootProcessEnginePlugin createMissingUserForAutoLoginPlugin(@NotNull CamundaLoginProperties camundaLoginProperties) {
        Intrinsics.checkNotNullParameter((Object)camundaLoginProperties, (String)"camundaLoginProperties");
        return new SpringBootProcessEnginePlugin(camundaLoginProperties){
            final /* synthetic */ CamundaLoginProperties $camundaLoginProperties;
            {
                this.$camundaLoginProperties = $camundaLoginProperties;
            }

            public void postProcessEngineBuild(ProcessEngine processEngine) {
                Intrinsics.checkNotNullParameter((Object)processEngine, (String)"processEngine");
                if (this.$camundaLoginProperties.getCreateIfAbsent() && processEngine.getIdentityService().createUserQuery().userId(this.$camundaLoginProperties.getUserId()).count() == 0L) {
                    processEngine.getIdentityService().saveUser((User)this.$camundaLoginProperties.extractUser());
                    CamundaLoginAutoConfigurationKt.access$getLogger$p().info(() -> createMissingUserForAutoLoginPlugin.1.postProcessEngineBuild$lambda$0(this.$camundaLoginProperties));
                }
            }

            private static final Object postProcessEngineBuild$lambda$0(CamundaLoginProperties $camundaLoginProperties) {
                return "Created the auto-login user '" + $camundaLoginProperties.extractUser().getId() + "'.";
            }
        };
    }

    private static final Object reportActivation$lambda$0() {
        return "Developer auto login is enabled by property. Don't use this in production.";
    }
}

