/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.correlate.persist;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.holunda.camunda.bpm.correlate.CamundaBpmCorrelateConfiguration;
import io.holunda.camunda.bpm.correlate.correlation.SingleMessageCorrelationStrategy;
import io.holunda.camunda.bpm.correlate.persist.MessagePersistenceService;
import io.holunda.camunda.bpm.correlate.persist.MessageRepository;
import io.holunda.camunda.bpm.correlate.persist.SingleMessageErrorHandlingStrategy;
import io.holunda.camunda.bpm.correlate.persist.encoding.JacksonJsonDecoder;
import io.holunda.camunda.bpm.correlate.persist.encoding.PayloadDecoder;
import io.holunda.camunda.bpm.correlate.persist.error.RetryingErrorHandlingConfig;
import io.holunda.camunda.bpm.correlate.persist.error.RetryingErrorHandlingProperties;
import io.holunda.camunda.bpm.correlate.persist.error.RetryingSingleMessageErrorHandlingStrategy;
import io.holunda.camunda.bpm.correlate.persist.impl.DefaultMessagePersistenceService;
import io.holunda.camunda.bpm.correlate.persist.impl.MessageManagementService;
import io.holunda.camunda.bpm.correlate.persist.impl.MessagePersistenceConfig;
import io.holunda.camunda.bpm.correlate.persist.impl.MessagePersistenceProperties;
import io.holunda.camunda.bpm.correlate.persist.impl.MyBatisMessageMapper;
import io.holunda.camunda.bpm.correlate.persist.impl.MyBatisMessageRepository;
import java.time.Clock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.session.SqlSessionFactory;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnBean(name={"messagePersistenceProperties"})
@AutoConfigureAfter(value={CamundaBpmCorrelateConfiguration.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\u0012\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J>\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0017\u00a8\u0006 "}, d2={"Lio/holunda/camunda/bpm/correlate/persist/MessagePersistenceConfiguration;", "", "<init>", "()V", "correlateObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "jacksonPayloadDecoder", "Lio/holunda/camunda/bpm/correlate/persist/encoding/PayloadDecoder;", "objectMapper", "registerMyBatisMappers", "", "processEngine", "Lorg/camunda/bpm/engine/ProcessEngine;", "messageRepository", "Lio/holunda/camunda/bpm/correlate/persist/MessageRepository;", "singleMessageErrorHandlingStrategy", "Lio/holunda/camunda/bpm/correlate/persist/SingleMessageErrorHandlingStrategy;", "retryingErrorHandlingProperties", "Lio/holunda/camunda/bpm/correlate/persist/error/RetryingErrorHandlingProperties;", "clock", "Ljava/time/Clock;", "messagePersistenceService", "Lio/holunda/camunda/bpm/correlate/persist/MessagePersistenceService;", "messagePersistenceProperties", "Lio/holunda/camunda/bpm/correlate/persist/impl/MessagePersistenceProperties;", "payloadDecoders", "", "singleMessageCorrelationStrategy", "Lio/holunda/camunda/bpm/correlate/correlation/SingleMessageCorrelationStrategy;", "messageCleanupService", "Lio/holunda/camunda/bpm/correlate/persist/impl/MessageManagementService;", "Companion", "camunda-bpm-correlate-spring-boot-starter"})
public class MessagePersistenceConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CORRELATE_OBJECT_MAPPER = "correlateObjectMapper";

    @Bean
    @ConditionalOnMissingBean(name={"correlateObjectMapper"})
    @Qualifier(value="correlateObjectMapper")
    @NotNull
    public ObjectMapper correlateObjectMapper() {
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"disable(...)");
        return objectMapper;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public PayloadDecoder jacksonPayloadDecoder(@Qualifier(value="correlateObjectMapper") @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return (PayloadDecoder)new JacksonJsonDecoder(objectMapper);
    }

    @Autowired
    public void registerMyBatisMappers(@NotNull ProcessEngine processEngine) {
        Intrinsics.checkNotNullParameter((Object)processEngine, (String)"processEngine");
        ProcessEngineConfiguration processEngineConfiguration = processEngine.getProcessEngineConfiguration();
        Intrinsics.checkNotNull((Object)processEngineConfiguration, (String)"null cannot be cast to non-null type org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl");
        ProcessEngineConfigurationImpl processEngineConfiguration2 = (ProcessEngineConfigurationImpl)processEngineConfiguration;
        MapperRegistry registry = processEngineConfiguration2.getSqlSessionFactory().getConfiguration().getMapperRegistry();
        boolean bl = false;
        if (!registry.hasMapper(MyBatisMessageMapper.class)) {
            registry.addMapper(MyBatisMessageMapper.class);
        }
    }

    @ConditionalOnMissingBean
    @Bean
    @NotNull
    public MessageRepository messageRepository(@NotNull ProcessEngine processEngine) {
        Intrinsics.checkNotNullParameter((Object)processEngine, (String)"processEngine");
        ProcessEngineConfiguration processEngineConfiguration = processEngine.getProcessEngineConfiguration();
        Intrinsics.checkNotNull((Object)processEngineConfiguration, (String)"null cannot be cast to non-null type org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl");
        ProcessEngineConfigurationImpl processEngineConfiguration2 = (ProcessEngineConfigurationImpl)processEngineConfiguration;
        SqlSessionFactory sqlSessionFactory = processEngineConfiguration2.getSqlSessionFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sqlSessionFactory, (String)"getSqlSessionFactory(...)");
        return (MessageRepository)new MyBatisMessageRepository(sqlSessionFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    @NotNull
    public SingleMessageErrorHandlingStrategy singleMessageErrorHandlingStrategy(@NotNull RetryingErrorHandlingProperties retryingErrorHandlingProperties, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)retryingErrorHandlingProperties, (String)"retryingErrorHandlingProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return (SingleMessageErrorHandlingStrategy)new RetryingSingleMessageErrorHandlingStrategy(clock, (RetryingErrorHandlingConfig)retryingErrorHandlingProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    @NotNull
    public MessagePersistenceService messagePersistenceService(@NotNull MessageRepository messageRepository, @NotNull MessagePersistenceProperties messagePersistenceProperties, @NotNull List<? extends PayloadDecoder> payloadDecoders, @NotNull Clock clock, @NotNull SingleMessageCorrelationStrategy singleMessageCorrelationStrategy, @NotNull SingleMessageErrorHandlingStrategy singleMessageErrorHandlingStrategy) {
        Intrinsics.checkNotNullParameter((Object)messageRepository, (String)"messageRepository");
        Intrinsics.checkNotNullParameter((Object)messagePersistenceProperties, (String)"messagePersistenceProperties");
        Intrinsics.checkNotNullParameter(payloadDecoders, (String)"payloadDecoders");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)singleMessageCorrelationStrategy, (String)"singleMessageCorrelationStrategy");
        Intrinsics.checkNotNullParameter((Object)singleMessageErrorHandlingStrategy, (String)"singleMessageErrorHandlingStrategy");
        return (MessagePersistenceService)new DefaultMessagePersistenceService((MessagePersistenceConfig)messagePersistenceProperties, messageRepository, payloadDecoders, clock, singleMessageCorrelationStrategy, singleMessageErrorHandlingStrategy);
    }

    @ConditionalOnMissingBean
    @Bean
    @NotNull
    public MessageManagementService messageCleanupService(@NotNull MessageRepository messageRepository, @NotNull MessagePersistenceProperties messagePersistenceProperties, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)messageRepository, (String)"messageRepository");
        Intrinsics.checkNotNullParameter((Object)messagePersistenceProperties, (String)"messagePersistenceProperties");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new MessageManagementService(messageRepository, (MessagePersistenceConfig)messagePersistenceProperties, clock);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/holunda/camunda/bpm/correlate/persist/MessagePersistenceConfiguration$Companion;", "", "<init>", "()V", "CORRELATE_OBJECT_MAPPER", "", "camunda-bpm-correlate-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

