/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.correlate.correlation;

import io.holunda.camunda.bpm.correlate.correlation.ClusterSetupConfigurationKt;
import io.holunda.camunda.bpm.correlate.persist.MessagePersistenceConfiguration;
import jakarta.annotation.PostConstruct;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@AutoConfiguration
@ConditionalOnProperty(value={"correlate.batch.cluster.enabled"}, havingValue="true", matchIfMissing=false)
@AutoConfigureAfter(value={MessagePersistenceConfiguration.class})
@EnableSchedulerLock(defaultLockAtMostFor="PT10M")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\n"}, d2={"Lio/holunda/camunda/bpm/correlate/correlation/ClusterSetupConfiguration;", "", "<init>", "()V", "printUsage", "", "messageCorrelationLockProvider", "Lnet/javacrumbs/shedlock/core/LockProvider;", "dataSource", "Ljavax/sql/DataSource;", "camunda-bpm-correlate-spring-boot-starter"})
public class ClusterSetupConfiguration {
    @PostConstruct
    public void printUsage() {
        ClusterSetupConfigurationKt.access$getLogger$p().info(ClusterSetupConfiguration::printUsage$lambda$0);
    }

    @Bean
    @NotNull
    public LockProvider messageCorrelationLockProvider(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return (LockProvider)new JdbcTemplateLockProvider(JdbcTemplateLockProvider.Configuration.builder().withJdbcTemplate(new JdbcTemplate(dataSource)).usingDbTime().build());
    }

    private static final Object printUsage$lambda$0() {
        return "[Camunda CORRELATE] Cluster configuration is activated.";
    }
}

