/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.correlate.correlation;

import io.github.oshai.kotlinlogging.KLogger;
import io.holunda.camunda.bpm.correlate.correlation.BatchConfigurationProperties;
import io.holunda.camunda.bpm.correlate.correlation.BatchCorrelationProcessor;
import io.holunda.camunda.bpm.correlate.correlation.BatchCorrelationSchedulerConfigurationKt;
import io.holunda.camunda.bpm.correlate.correlation.CorrelationMetrics;
import io.holunda.camunda.bpm.correlate.persist.MessageEntity;
import io.holunda.camunda.bpm.correlate.persist.MessagePersistenceConfiguration;
import io.holunda.camunda.bpm.correlate.persist.impl.MessageManagementService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@AutoConfiguration
@EnableScheduling
@AutoConfigureAfter(value={MessagePersistenceConfiguration.class})
@ConditionalOnBean(name={"batchConfigurationProperties"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\rH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/holunda/camunda/bpm/correlate/correlation/BatchCorrelationSchedulerConfiguration;", "Lorg/springframework/scheduling/annotation/SchedulingConfigurer;", "batchCorrelationProcessor", "Lio/holunda/camunda/bpm/correlate/correlation/BatchCorrelationProcessor;", "messageManagementService", "Lio/holunda/camunda/bpm/correlate/persist/impl/MessageManagementService;", "batchConfigurationProperties", "Lio/holunda/camunda/bpm/correlate/correlation/BatchConfigurationProperties;", "correlationMetrics", "Lio/holunda/camunda/bpm/correlate/correlation/CorrelationMetrics;", "<init>", "(Lio/holunda/camunda/bpm/correlate/correlation/BatchCorrelationProcessor;Lio/holunda/camunda/bpm/correlate/persist/impl/MessageManagementService;Lio/holunda/camunda/bpm/correlate/correlation/BatchConfigurationProperties;Lio/holunda/camunda/bpm/correlate/correlation/CorrelationMetrics;)V", "runCorrelation", "", "cleanupExpired", "correlateTaskExecutor", "Ljava/util/concurrent/Executor;", "configureTasks", "taskRegistrar", "Lorg/springframework/scheduling/config/ScheduledTaskRegistrar;", "camunda-bpm-correlate-spring-boot-starter"})
@SourceDebugExtension(value={"SMAP\nBatchCorrelationSchedulerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BatchCorrelationSchedulerConfiguration.kt\nio/holunda/camunda/bpm/correlate/correlation/BatchCorrelationSchedulerConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1869#2,2:88\n*S KotlinDebug\n*F\n+ 1 BatchCorrelationSchedulerConfiguration.kt\nio/holunda/camunda/bpm/correlate/correlation/BatchCorrelationSchedulerConfiguration\n*L\n57#1:88,2\n*E\n"})
public class BatchCorrelationSchedulerConfiguration
implements SchedulingConfigurer {
    @NotNull
    private final BatchCorrelationProcessor batchCorrelationProcessor;
    @NotNull
    private final MessageManagementService messageManagementService;
    @NotNull
    private final BatchConfigurationProperties batchConfigurationProperties;
    @NotNull
    private final CorrelationMetrics correlationMetrics;

    public BatchCorrelationSchedulerConfiguration(@NotNull BatchCorrelationProcessor batchCorrelationProcessor, @NotNull MessageManagementService messageManagementService, @NotNull BatchConfigurationProperties batchConfigurationProperties, @NotNull CorrelationMetrics correlationMetrics) {
        Intrinsics.checkNotNullParameter((Object)batchCorrelationProcessor, (String)"batchCorrelationProcessor");
        Intrinsics.checkNotNullParameter((Object)messageManagementService, (String)"messageManagementService");
        Intrinsics.checkNotNullParameter((Object)batchConfigurationProperties, (String)"batchConfigurationProperties");
        Intrinsics.checkNotNullParameter((Object)correlationMetrics, (String)"correlationMetrics");
        this.batchCorrelationProcessor = batchCorrelationProcessor;
        this.messageManagementService = messageManagementService;
        this.batchConfigurationProperties = batchConfigurationProperties;
        this.correlationMetrics = correlationMetrics;
    }

    @Scheduled(fixedRateString="#{batchConfigurationProperties.queryPollInterval}", initialDelayString="#{batchConfigurationProperties.queryPollInitialDelay}")
    @SchedulerLock(name="message-correlation", lockAtMostFor="#{batchConfigurationProperties.getQueuePollLockMostInterval()}")
    public void runCorrelation() {
        this.batchCorrelationProcessor.correlate();
        this.correlationMetrics.reportMessageCounts(this.messageManagementService.countMessagesByStatus());
        if (KLogger.DefaultImpls.isTraceEnabled$default((KLogger)BatchCorrelationSchedulerConfigurationKt.access$getLogger$p(), null, (int)1, null)) {
            List remaining = this.messageManagementService.listAllMessages();
            if (!((Collection)remaining).isEmpty()) {
                BatchCorrelationSchedulerConfigurationKt.access$getLogger$p().trace(() -> BatchCorrelationSchedulerConfiguration.runCorrelation$lambda$0(remaining));
            }
            Iterable $this$forEach$iv = remaining;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MessageEntity it = (MessageEntity)element$iv;
                boolean bl = false;
                BatchCorrelationSchedulerConfigurationKt.access$getLogger$p().trace(() -> BatchCorrelationSchedulerConfiguration.runCorrelation$lambda$1$0(it));
            }
        }
    }

    @Scheduled(fixedRateString="#{batchConfigurationProperties.cleanupPollInterval}", initialDelayString="#{batchConfigurationProperties.cleanupPollInitialDelay}")
    public void cleanupExpired() {
        this.messageManagementService.cleanupExpired();
    }

    @Bean(destroyMethod="shutdown")
    @Qualifier(value="correlateTaskExecutor")
    @NotNull
    public Executor correlateTaskExecutor() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(100);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
        return scheduledExecutorService;
    }

    public void configureTasks(@NotNull ScheduledTaskRegistrar taskRegistrar) {
        Intrinsics.checkNotNullParameter((Object)taskRegistrar, (String)"taskRegistrar");
    }

    private static final Object runCorrelation$lambda$0(List $remaining) {
        return "There are " + $remaining.size() + " messages in the message inbox.";
    }

    private static final Object runCorrelation$lambda$1$0(MessageEntity $it) {
        return "Message with payload type " + $it.getPayloadTypeNamespace() + "." + $it.getPayloadTypeName() + " received at " + $it.getInserted() + ", attempts: " + $it.getRetries() + ", next due at: " + $it.getNextRetry() + ".";
    }
}

