/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.correlate.correlation;

import io.holunda.camunda.bpm.correlate.correlation.BatchConfigurationProperties;
import io.holunda.camunda.bpm.correlate.correlation.BatchCorrelationMode;
import io.holunda.camunda.bpm.correlate.correlation.BatchCorrelationProcessor;
import io.holunda.camunda.bpm.correlate.correlation.BatchCorrelationService;
import io.holunda.camunda.bpm.correlate.correlation.CorrelationMetrics;
import io.holunda.camunda.bpm.correlate.correlation.impl.CamundaBpmBatchCorrelationService;
import io.holunda.camunda.bpm.correlate.correlation.impl.TransactionalRuntimeServiceWrapper;
import io.holunda.camunda.bpm.correlate.event.CamundaCorrelationEventFactoryRegistry;
import io.holunda.camunda.bpm.correlate.persist.MessagePersistenceConfiguration;
import io.holunda.camunda.bpm.correlate.persist.MessagePersistenceService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.bpm.engine.RuntimeService;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AutoConfiguration
@ConditionalOnBean(name={"batchConfigurationProperties"})
@AutoConfigureAfter(value={MessagePersistenceConfiguration.class})
@EnableTransactionManagement
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\"\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017\u00a8\u0006\u0015"}, d2={"Lio/holunda/camunda/bpm/correlate/correlation/BatchCorrelationConfiguration;", "", "<init>", "()V", "transactionalRuntimeServiceWrapper", "Lio/holunda/camunda/bpm/correlate/correlation/impl/TransactionalRuntimeServiceWrapper;", "runtimeService", "Lorg/camunda/bpm/engine/RuntimeService;", "batchCorrelationService", "Lio/holunda/camunda/bpm/correlate/correlation/BatchCorrelationService;", "registry", "Lio/holunda/camunda/bpm/correlate/event/CamundaCorrelationEventFactoryRegistry;", "batchConfigurationProperties", "Lio/holunda/camunda/bpm/correlate/correlation/BatchConfigurationProperties;", "batchCorrelationProcessor", "Lio/holunda/camunda/bpm/correlate/correlation/BatchCorrelationProcessor;", "persistenceService", "Lio/holunda/camunda/bpm/correlate/persist/MessagePersistenceService;", "correlationMetrics", "Lio/holunda/camunda/bpm/correlate/correlation/CorrelationMetrics;", "Companion", "camunda-bpm-correlate-spring-boot-starter"})
public class BatchCorrelationConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TRANSACTIONAL_RUNTIME_SERVICE = "transactionalRuntimeService";

    @ConditionalOnMissingBean
    @Bean
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Qualifier(value="transactionalRuntimeService")
    @NotNull
    public TransactionalRuntimeServiceWrapper transactionalRuntimeServiceWrapper(@NotNull RuntimeService runtimeService) {
        Intrinsics.checkNotNullParameter((Object)runtimeService, (String)"runtimeService");
        return new TransactionalRuntimeServiceWrapper(runtimeService);
    }

    @ConditionalOnMissingBean
    @Bean
    @NotNull
    public BatchCorrelationService batchCorrelationService(@Qualifier(value="transactionalRuntimeService") @NotNull RuntimeService runtimeService, @NotNull CamundaCorrelationEventFactoryRegistry registry, @NotNull BatchConfigurationProperties batchConfigurationProperties) {
        Intrinsics.checkNotNullParameter((Object)runtimeService, (String)"runtimeService");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)batchConfigurationProperties, (String)"batchConfigurationProperties");
        BatchCorrelationMode batchCorrelationMode = batchConfigurationProperties.getMode();
        return (BatchCorrelationService)new CamundaBpmBatchCorrelationService(registry, runtimeService, batchCorrelationMode);
    }

    @Bean
    @NotNull
    public BatchCorrelationProcessor batchCorrelationProcessor(@NotNull MessagePersistenceService persistenceService, @NotNull BatchCorrelationService batchCorrelationService, @NotNull CorrelationMetrics correlationMetrics) {
        Intrinsics.checkNotNullParameter((Object)persistenceService, (String)"persistenceService");
        Intrinsics.checkNotNullParameter((Object)batchCorrelationService, (String)"batchCorrelationService");
        Intrinsics.checkNotNullParameter((Object)correlationMetrics, (String)"correlationMetrics");
        return new BatchCorrelationProcessor(persistenceService, batchCorrelationService, correlationMetrics);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/holunda/camunda/bpm/correlate/correlation/BatchCorrelationConfiguration$Companion;", "", "<init>", "()V", "TRANSACTIONAL_RUNTIME_SERVICE", "", "camunda-bpm-correlate-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

