/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.correlate.resources;

import io.holunda.camunda.bpm.correlate.CamundaBpmCorrelateCockpitPluginKt;
import io.holunda.camunda.bpm.correlate.CamundaBpmCorrelateServices;
import io.holunda.camunda.bpm.correlate.dto.MessageDto;
import io.holunda.camunda.bpm.correlate.dto.MessageDtoKt;
import io.holunda.camunda.bpm.correlate.dto.RetriesDto;
import io.holunda.camunda.bpm.correlate.persist.MessageEntity;
import io.holunda.camunda.bpm.correlate.persist.impl.MessageManagementService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.bpm.cockpit.plugin.resource.AbstractCockpitPluginResource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000eH\u0007J\u001a\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0012\u0010\u0015\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0003H\u0007J\u0012\u0010\u0016\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0003H\u0007J\u0012\u0010\u0017\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0003H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/holunda/camunda/bpm/correlate/resources/CorrelateMessageResource;", "Lorg/camunda/bpm/cockpit/plugin/resource/AbstractCockpitPluginResource;", "engineName", "", "<init>", "(Ljava/lang/String;)V", "services", "Lio/holunda/camunda/bpm/correlate/CamundaBpmCorrelateServices;", "getMessages", "", "Lio/holunda/camunda/bpm/correlate/dto/MessageDto;", "faults", "", "page", "", "size", "changeMassageRetries", "", "messageId", "retriesDto", "Lio/holunda/camunda/bpm/correlate/dto/RetriesDto;", "pauseMessage", "resumeMessage", "deleteMessage", "camunda-bpm-correlate-cockpit-plugin"})
@SourceDebugExtension(value={"SMAP\nCorrelateMessageResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorrelateMessageResource.kt\nio/holunda/camunda/bpm/correlate/resources/CorrelateMessageResource\n+ 2 CamundaBpmCorrelateCockpitPlugin.kt\nio/holunda/camunda/bpm/correlate/CamundaBpmCorrelateCockpitPluginKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n49#2:72\n1563#3:73\n1634#3,3:74\n*S KotlinDebug\n*F\n+ 1 CorrelateMessageResource.kt\nio/holunda/camunda/bpm/correlate/resources/CorrelateMessageResource\n*L\n17#1:72\n28#1:73\n28#1:74,3\n*E\n"})
public final class CorrelateMessageResource
extends AbstractCockpitPluginResource {
    @NotNull
    private final CamundaBpmCorrelateServices services;

    public CorrelateMessageResource(@NotNull String engineName) {
        Intrinsics.checkNotNullParameter((Object)engineName, (String)"engineName");
        super(engineName);
        AbstractCockpitPluginResource abstractCockpitPluginResource = this;
        Class<CamundaBpmCorrelateServices> clazz$iv = CamundaBpmCorrelateServices.class;
        boolean $i$f$getBean = false;
        Object object = CamundaBpmCorrelateCockpitPluginKt.getApplicationContext().getBean(clazz$iv);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
        this.services = (CamundaBpmCorrelateServices)object;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Produces(value={"application/json"})
    @NotNull
    public final List<MessageDto> getMessages(@QueryParam(value="faultsOnly") boolean faults, @QueryParam(value="page") int page, @QueryParam(value="size") int size) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.services.getMessageRepository().findAllLight(page, size, faults);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MessageEntity messageEntity = (MessageEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MessageDtoKt.toDto((MessageEntity)it, this.services.getConfiguration().getPersistence().getMessageMaxRetries()));
        }
        return (List)destination$iv$iv;
    }

    @POST
    @Path(value="/{messageId}/retries")
    @Consumes(value={"application/json"})
    public final void changeMassageRetries(@PathParam(value="messageId") @NotNull String messageId, @NotNull RetriesDto retriesDto) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)retriesDto, (String)"retriesDto");
        MessageManagementService messageManagementService = this.services.getMessageManagementService();
        int n = retriesDto.getRetries();
        Instant instant = retriesDto.getNextRetry().toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        messageManagementService.changeMessageRetries(messageId, n, instant);
    }

    @PUT
    @Path(value="/{messageId}/pause")
    @Consumes(value={"application/json"})
    public final void pauseMessage(@PathParam(value="messageId") @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        this.services.getMessageManagementService().pauseMessageProcessing(messageId);
    }

    @DELETE
    @Path(value="/{messageId}/pause")
    @Consumes(value={"application/json"})
    public final void resumeMessage(@PathParam(value="messageId") @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        this.services.getMessageManagementService().resumeMessageProcessing(messageId);
    }

    @DELETE
    @Path(value="/{messageId}")
    @Consumes(value={"application/json"})
    public final void deleteMessage(@PathParam(value="messageId") @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        this.services.getMessageManagementService().deleteMessage(messageId);
    }
}

