/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.spring.boot.starter.externaldatasource;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class PropertyProvider {
    private static final Logger log = LoggerFactory.getLogger(PropertyProvider.class);
    private static final String ENVIRONMENT_VARIABLE_REGEX = "^(\\$\\{.+\\})*$";
    private final Environment environment;

    public String getProperty(String propertyName) {
        String propertyValue = this.environment.getProperty(propertyName);
        if (StringUtils.isBlank((CharSequence)propertyValue)) {
            log.warn("property not found: {}", (Object)propertyName);
            return propertyValue;
        }
        return this.propertyValueIsEnvironmentVariable(propertyValue) ? this.getEnvironmentValue(propertyValue) : propertyValue;
    }

    private boolean propertyValueIsEnvironmentVariable(String propertyValue) {
        return propertyValue.matches(ENVIRONMENT_VARIABLE_REGEX);
    }

    private String getEnvironmentValue(String value) {
        String environmentVariable = StringUtils.substringBetween((String)value, (String)"${", (String)"}");
        log.debug("looking for environment variable: {}", (Object)environmentVariable);
        String environmentValue = System.getenv(environmentVariable);
        log.debug("found environment value: {}", (Object)environmentValue);
        return environmentValue;
    }

    public PropertyProvider(Environment environment) {
        this.environment = environment;
    }
}

