/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.spring.boot.starter;

import com.zaxxer.hikari.HikariDataSource;
import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.core.HigsonEngineFactory;
import io.higson.runtime.spring.boot.starter.HigsonRuntimeProperties;
import io.higson.runtime.spring.boot.starter.externaldatasource.ExternalDataSourceProvider;
import io.higson.runtime.spring.boot.starter.externaldatasource.PropertyProvider;
import io.higson.runtime.sql.DialectRegistry;
import io.higson.runtime.sql.DialectTemplate;
import io.higson.runtime.sql.dialect.DialectParser;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnClass(value={HigsonEngine.class})
@ConditionalOnProperty(value={"higson.runtime.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={HigsonRuntimeProperties.class})
public class HigsonRuntimeAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HigsonEngine higsonEngine(HigsonRuntimeProperties properties, @Qualifier(value="higsonDataSource") DataSource dataSource, ExternalDataSourceProvider externalDataSourceProvider) {
        HigsonEngineFactory factory = new HigsonEngineFactory(dataSource);
        factory.setDeveloperMode(properties.getRuntime().isDevModeEnabled());
        factory.setUsername(properties.getRuntime().getUsername());
        factory.setMaxConcurrentLoads(properties.getRuntime().getMaxConcurrentLoads());
        factory.setWatcherPauseSeconds(properties.getRuntime().getWatcher().getPauseSeconds());
        factory.setWatcherForceSyncSeconds(properties.getRuntime().getWatcher().getForceSyncSeconds());
        factory.setValidateFunctionArgumentsDataTypes(properties.getRuntime().getFunction().isValidateArguments());
        factory.setThrowOnNormalizeInputValueException(properties.getRuntime().getNormalization().isThrowOnException());
        factory.setGroovySecured(properties.getRuntime().getGroovy().isSecured());
        factory.setExternalDataSources(externalDataSourceProvider.getDataSources());
        return factory.create();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSource higsonDataSource(HigsonRuntimeProperties properties, @Qualifier(value="runtimeDialectTemplate") DialectTemplate dialectTemplate) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setUsername(properties.getDatabase().getUsername());
        dataSource.setPassword(properties.getDatabase().getPassword());
        dataSource.setJdbcUrl(properties.getDatabase().getUrl());
        dataSource.setDriverClassName(dialectTemplate.getJdbcDriverClassName());
        return dataSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public DialectTemplate runtimeDialectTemplate(HigsonRuntimeProperties properties) {
        DialectRegistry dialectRegistry = new DialectRegistry();
        dialectRegistry.setDialect((Object)DialectParser.getDatabaseDialect((String)properties.getDatabase().getUrl()));
        return dialectRegistry.create();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExternalDataSourceProvider externalDataSourceProvider(Environment environment, @Qualifier(value="higsonDataSource") DataSource dataSource) {
        PropertyProvider propertyProvider = new PropertyProvider(environment);
        String externalDataSourceNames = propertyProvider.getProperty("higson.runtime.external-datasource.sql.names");
        ExternalDataSourceProvider externalDataSourceProvider = new ExternalDataSourceProvider(externalDataSourceNames, propertyProvider);
        externalDataSourceProvider.configure(dataSource);
        return externalDataSourceProvider;
    }
}

