/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jackson.common;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.jackson.common.JacksonBodyReader;
import io.helidon.media.jackson.common.JacksonBodyWriter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class JacksonSupport
implements MediaSupport {
    private static final ObjectMapper MAPPER;
    private static final JacksonSupport DEFAULT_JACKSON;
    private final ObjectMapper objectMapper;

    private JacksonSupport(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static JacksonBodyReader reader() {
        return JacksonSupport.create().newReader();
    }

    public static JacksonBodyWriter writer() {
        return JacksonSupport.create().newWriter();
    }

    public JacksonBodyReader newReader() {
        return JacksonBodyReader.create(this.objectMapper);
    }

    public JacksonBodyWriter newWriter() {
        return JacksonBodyWriter.create(this.objectMapper);
    }

    public Collection<MessageBodyReader<?>> readers() {
        return List.of(this.newReader());
    }

    public Collection<MessageBodyWriter<?>> writers() {
        return List.of(this.newWriter());
    }

    public static JacksonSupport create(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        return new JacksonSupport(objectMapper);
    }

    public static JacksonSupport create() {
        return DEFAULT_JACKSON;
    }

    static {
        HelidonFeatures.register((HelidonFlavor)HelidonFlavor.SE, (String[])new String[]{"Media", "Jackson"});
        MAPPER = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
        DEFAULT_JACKSON = new JacksonSupport(MAPPER);
    }
}

